/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.work.AbstractHeartbeatWork;

public class JobletCleanupNotificationWork
extends AbstractHeartbeatWork {
    private static final Logger LOGGER = Logger.getLogger(JobletCleanupNotificationWork.class.getName());
    private ClusterControllerService ccs;
    private JobId jobId;
    private String nodeId;

    public JobletCleanupNotificationWork(ClusterControllerService ccs, JobId jobId, String nodeId) {
        super(ccs, nodeId, null);
        this.ccs = ccs;
        this.jobId = jobId;
        this.nodeId = nodeId;
    }

    @Override
    public void runWork() {
        IJobManager jobManager = this.ccs.getJobManager();
        JobRun run = jobManager.get(this.jobId);
        Set<String> cleanupPendingNodes = run.getCleanupPendingNodeIds();
        if (!cleanupPendingNodes.remove(this.nodeId)) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(this.nodeId + " not in pending cleanup nodes set: " + cleanupPendingNodes + " for Job: " + this.jobId);
            }
            return;
        }
        INodeManager nodeManager = this.ccs.getNodeManager();
        NodeControllerState ncs = nodeManager.getNodeControllerState(this.nodeId);
        if (ncs != null) {
            ncs.getActiveJobIds().remove(this.jobId);
        }
        if (cleanupPendingNodes.isEmpty()) {
            try {
                jobManager.finalComplete(run);
            }
            catch (HyracksException e) {
                ArrayList<Exception> completionException = new ArrayList<Exception>();
                if (run.getExceptions() != null && !run.getExceptions().isEmpty()) {
                    completionException.addAll(run.getExceptions());
                }
                completionException.add(0, (Exception)((Object)e));
                run.setStatus(JobStatus.FAILURE, completionException);
            }
        }
    }
}

