/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.work.AbstractWork;

public class JobCleanupWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(JobCleanupWork.class.getName());
    private IJobManager jobManager;
    private JobId jobId;
    private JobStatus status;
    private List<Exception> exceptions;

    public JobCleanupWork(IJobManager jobManager, JobId jobId, JobStatus status, List<Exception> exceptions) {
        this.jobManager = jobManager;
        this.jobId = jobId;
        this.status = status;
        this.exceptions = exceptions;
    }

    public void run() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Cleanup for JobRun with id: " + this.jobId);
        }
        try {
            JobRun jobRun = this.jobManager.get(this.jobId);
            this.jobManager.prepareComplete(jobRun, this.status, this.exceptions);
        }
        catch (HyracksException e) {
            JobRun run = this.jobManager.get(this.jobId);
            ArrayList<Exception> completionException = new ArrayList<Exception>();
            if (run.getExceptions() != null && !run.getExceptions().isEmpty()) {
                completionException.addAll(run.getExceptions());
            }
            completionException.add(0, (Exception)((Object)e));
            run.setStatus(JobStatus.FAILURE, completionException);
        }
    }

    public String toString() {
        return this.getName() + ": JobId@" + this.jobId + " Status@" + this.status + (this.exceptions == null ? "" : " Exceptions@" + this.exceptions);
    }
}

