/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.io.Serializable;
import java.util.EnumSet;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.IActivityClusterGraphGenerator;
import org.apache.hyracks.api.job.IActivityClusterGraphGeneratorFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class DistributeJobWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final byte[] acggfBytes;
    private final JobId jobId;
    private final IResultCallback<JobId> callback;

    public DistributeJobWork(ClusterControllerService ccs, byte[] acggfBytes, JobId jobId, IResultCallback<JobId> callback) {
        this.jobId = jobId;
        this.ccs = ccs;
        this.acggfBytes = acggfBytes;
        this.callback = callback;
    }

    protected void doRun() throws Exception {
        try {
            CCServiceContext ccServiceCtx = this.ccs.getContext();
            this.ccs.getPreDistributedJobStore().checkForExistingDistributedJobDescriptor(this.jobId);
            IActivityClusterGraphGeneratorFactory acggf = (IActivityClusterGraphGeneratorFactory)DeploymentUtils.deserialize((byte[])this.acggfBytes, null, (IServiceContext)ccServiceCtx);
            IActivityClusterGraphGenerator acgg = acggf.createActivityClusterGraphGenerator(this.jobId, (ICCServiceContext)ccServiceCtx, EnumSet.noneOf(JobFlag.class));
            ActivityClusterGraph acg = acgg.initialize();
            this.ccs.getPreDistributedJobStore().addDistributedJobDescriptor(this.jobId, acg, acggf.getJobSpecification(), acgg.getConstraints());
            ccServiceCtx.notifyJobCreation(this.jobId, acggf.getJobSpecification());
            byte[] acgBytes = JavaSerializationUtils.serialize((Serializable)acg);
            INodeManager nodeManager = this.ccs.getNodeManager();
            for (NodeControllerState node : nodeManager.getAllNodeControllerStates()) {
                node.getNodeController().distributeJob(this.jobId, acgBytes);
            }
            this.callback.setValue((Object)this.jobId);
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

