/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;

public class PreDistributedJobStore {
    private final Map<JobId, PreDistributedJobDescriptor> preDistributedJobDescriptorMap = new Hashtable<JobId, PreDistributedJobDescriptor>();

    public void addDistributedJobDescriptor(JobId jobId, ActivityClusterGraph activityClusterGraph, JobSpecification jobSpecification, Set<Constraint> activityClusterGraphConstraints) throws HyracksException {
        if (this.preDistributedJobDescriptorMap.get(jobId) != null) {
            throw HyracksException.create((int)22, (Serializable[])new Serializable[]{jobId});
        }
        PreDistributedJobDescriptor descriptor = new PreDistributedJobDescriptor(activityClusterGraph, jobSpecification, activityClusterGraphConstraints);
        this.preDistributedJobDescriptorMap.put(jobId, descriptor);
    }

    public void checkForExistingDistributedJobDescriptor(JobId jobId) throws HyracksException {
        if (this.preDistributedJobDescriptorMap.get(jobId) != null) {
            throw HyracksException.create((int)22, (Serializable[])new Serializable[]{jobId});
        }
    }

    public PreDistributedJobDescriptor getDistributedJobDescriptor(JobId jobId) throws HyracksException {
        PreDistributedJobDescriptor descriptor = this.preDistributedJobDescriptorMap.get(jobId);
        if (descriptor == null) {
            throw HyracksException.create((int)21, (Serializable[])new Serializable[]{jobId});
        }
        return descriptor;
    }

    public boolean jobIsPredistributed(JobId jobId) {
        return this.preDistributedJobDescriptorMap.get(jobId) != null;
    }

    public void removeDistributedJobDescriptor(JobId jobId) throws HyracksException {
        PreDistributedJobDescriptor descriptor = this.preDistributedJobDescriptorMap.get(jobId);
        if (descriptor == null) {
            throw HyracksException.create((int)21, (Serializable[])new Serializable[]{jobId});
        }
        this.preDistributedJobDescriptorMap.remove(jobId);
    }

    public class PreDistributedJobDescriptor {
        private final ActivityClusterGraph activityClusterGraph;
        private final JobSpecification jobSpecification;
        private final Set<Constraint> activityClusterGraphConstraints;

        private PreDistributedJobDescriptor(ActivityClusterGraph activityClusterGraph, JobSpecification jobSpecification, Set<Constraint> activityClusterGraphConstraints) {
            this.activityClusterGraph = activityClusterGraph;
            this.jobSpecification = jobSpecification;
            this.activityClusterGraphConstraints = activityClusterGraphConstraints;
        }

        public ActivityClusterGraph getActivityClusterGraph() {
            return this.activityClusterGraph;
        }

        public JobSpecification getJobSpecification() {
            return this.jobSpecification;
        }

        public Set<Constraint> getActivityClusterGraphConstraints() {
            return this.activityClusterGraphConstraints;
        }
    }
}

