/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.client.HyracksClientInterfaceFunctions;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataset.DatasetDirectoryRecord;
import org.apache.hyracks.api.dataset.DatasetJobRecord;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobIdFactory;
import org.apache.hyracks.api.job.JobInfo;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.work.CancelJobWork;
import org.apache.hyracks.control.cc.work.CliDeployBinaryWork;
import org.apache.hyracks.control.cc.work.CliUnDeployBinaryWork;
import org.apache.hyracks.control.cc.work.ClusterShutdownWork;
import org.apache.hyracks.control.cc.work.DestroyJobWork;
import org.apache.hyracks.control.cc.work.DistributeJobWork;
import org.apache.hyracks.control.cc.work.GetDatasetDirectoryServiceInfoWork;
import org.apache.hyracks.control.cc.work.GetJobInfoWork;
import org.apache.hyracks.control.cc.work.GetJobStatusWork;
import org.apache.hyracks.control.cc.work.GetNodeControllersInfoWork;
import org.apache.hyracks.control.cc.work.GetNodeDetailsJSONWork;
import org.apache.hyracks.control.cc.work.GetResultPartitionLocationsWork;
import org.apache.hyracks.control.cc.work.GetResultStatusWork;
import org.apache.hyracks.control.cc.work.GetThreadDumpWork;
import org.apache.hyracks.control.cc.work.JobStartWork;
import org.apache.hyracks.control.cc.work.WaitForJobCompletionWork;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.IPCResponder;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.exceptions.IPCException;

class ClientInterfaceIPCI
implements IIPCI {
    private static final Logger LOGGER = Logger.getLogger(ClientInterfaceIPCI.class.getName());
    private final ClusterControllerService ccs;
    private final JobIdFactory jobIdFactory;

    ClientInterfaceIPCI(ClusterControllerService ccs, JobIdFactory jobIdFactory) {
        this.ccs = ccs;
        this.jobIdFactory = jobIdFactory;
    }

    public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload, Exception exception) {
        HyracksClientInterfaceFunctions.Function fn = (HyracksClientInterfaceFunctions.Function)payload;
        switch (fn.getFunctionId()) {
            case GET_CLUSTER_CONTROLLER_INFO: {
                try {
                    handle.send(mid, (Object)this.ccs.getClusterControllerInfo(), null);
                }
                catch (IPCException e) {
                    LOGGER.log(Level.WARNING, "Error sending response to GET_CLUSTER_CONTROLLER_INFO request", e);
                }
                break;
            }
            case GET_JOB_STATUS: {
                HyracksClientInterfaceFunctions.GetJobStatusFunction gjsf = (HyracksClientInterfaceFunctions.GetJobStatusFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetJobStatusWork(this.ccs.getJobManager(), gjsf.getJobId(), (IResultCallback<JobStatus>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_JOB_INFO: {
                HyracksClientInterfaceFunctions.GetJobInfoFunction gjif = (HyracksClientInterfaceFunctions.GetJobInfoFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetJobInfoWork(this.ccs.getJobManager(), gjif.getJobId(), (IResultCallback<JobInfo>)new IPCResponder(handle, mid)));
                break;
            }
            case DISTRIBUTE_JOB: {
                HyracksClientInterfaceFunctions.DistributeJobFunction djf = (HyracksClientInterfaceFunctions.DistributeJobFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new DistributeJobWork(this.ccs, djf.getACGGFBytes(), this.jobIdFactory.create(), (IResultCallback<JobId>)new IPCResponder(handle, mid)));
                break;
            }
            case DESTROY_JOB: {
                HyracksClientInterfaceFunctions.DestroyJobFunction dsjf = (HyracksClientInterfaceFunctions.DestroyJobFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new DestroyJobWork(this.ccs, dsjf.getJobId(), (IResultCallback<JobId>)new IPCResponder(handle, mid)));
                break;
            }
            case CANCEL_JOB: {
                HyracksClientInterfaceFunctions.CancelJobFunction cjf = (HyracksClientInterfaceFunctions.CancelJobFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new CancelJobWork(this.ccs.getJobManager(), cjf.getJobId(), (IResultCallback<Void>)new IPCResponder(handle, mid)));
                break;
            }
            case START_JOB: {
                HyracksClientInterfaceFunctions.StartJobFunction sjf = (HyracksClientInterfaceFunctions.StartJobFunction)fn;
                JobId jobId = sjf.getJobId();
                byte[] acggfBytes = null;
                boolean predistributed = false;
                if (jobId == null) {
                    jobId = this.jobIdFactory.create();
                    acggfBytes = sjf.getACGGFBytes();
                } else {
                    predistributed = true;
                }
                this.ccs.getWorkQueue().schedule((AbstractWork)new JobStartWork(this.ccs, sjf.getDeploymentId(), acggfBytes, sjf.getJobFlags(), jobId, (IResultCallback<JobId>)new IPCResponder(handle, mid), predistributed));
                break;
            }
            case GET_DATASET_DIRECTORY_SERIVICE_INFO: {
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetDatasetDirectoryServiceInfoWork(this.ccs, (IResultCallback<NetworkAddress>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_DATASET_RESULT_STATUS: {
                HyracksClientInterfaceFunctions.GetDatasetResultStatusFunction gdrsf = (HyracksClientInterfaceFunctions.GetDatasetResultStatusFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetResultStatusWork(this.ccs, gdrsf.getJobId(), gdrsf.getResultSetId(), (IResultCallback<DatasetJobRecord.Status>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_DATASET_RESULT_LOCATIONS: {
                HyracksClientInterfaceFunctions.GetDatasetResultLocationsFunction gdrlf = (HyracksClientInterfaceFunctions.GetDatasetResultLocationsFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetResultPartitionLocationsWork(this.ccs, gdrlf.getJobId(), gdrlf.getResultSetId(), gdrlf.getKnownRecords(), (IResultCallback<DatasetDirectoryRecord[]>)new IPCResponder(handle, mid)));
                break;
            }
            case WAIT_FOR_COMPLETION: {
                HyracksClientInterfaceFunctions.WaitForCompletionFunction wfcf = (HyracksClientInterfaceFunctions.WaitForCompletionFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new WaitForJobCompletionWork(this.ccs, wfcf.getJobId(), (IResultCallback<Object>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_NODE_CONTROLLERS_INFO: {
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetNodeControllersInfoWork(this.ccs.getNodeManager(), (IResultCallback<Map<String, NodeControllerInfo>>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_CLUSTER_TOPOLOGY: {
                try {
                    handle.send(mid, (Object)this.ccs.getCCContext().getClusterTopology(), null);
                }
                catch (IPCException e) {
                    LOGGER.log(Level.WARNING, "Error sending response to GET_CLUSTER_TOPOLOGY request", e);
                }
                break;
            }
            case CLI_DEPLOY_BINARY: {
                HyracksClientInterfaceFunctions.CliDeployBinaryFunction dbf = (HyracksClientInterfaceFunctions.CliDeployBinaryFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new CliDeployBinaryWork(this.ccs, dbf.getBinaryURLs(), dbf.getDeploymentId(), (IPCResponder<DeploymentId>)new IPCResponder(handle, mid)));
                break;
            }
            case CLI_UNDEPLOY_BINARY: {
                HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction udbf = (HyracksClientInterfaceFunctions.CliUnDeployBinaryFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new CliUnDeployBinaryWork(this.ccs, udbf.getDeploymentId(), (IPCResponder<DeploymentId>)new IPCResponder(handle, mid)));
                break;
            }
            case CLUSTER_SHUTDOWN: {
                HyracksClientInterfaceFunctions.ClusterShutdownFunction csf = (HyracksClientInterfaceFunctions.ClusterShutdownFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new ClusterShutdownWork(this.ccs, csf.isTerminateNCService(), (IResultCallback<Boolean>)new IPCResponder(handle, mid)));
                break;
            }
            case GET_NODE_DETAILS_JSON: {
                HyracksClientInterfaceFunctions.GetNodeDetailsJSONFunction gndjf = (HyracksClientInterfaceFunctions.GetNodeDetailsJSONFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetNodeDetailsJSONWork(this.ccs.getNodeManager(), this.ccs.getCCConfig(), gndjf.getNodeId(), gndjf.isIncludeStats(), gndjf.isIncludeConfig(), (IPCResponder<String>)new IPCResponder(handle, mid)));
                break;
            }
            case THREAD_DUMP: {
                HyracksClientInterfaceFunctions.ThreadDumpFunction tdf = (HyracksClientInterfaceFunctions.ThreadDumpFunction)fn;
                this.ccs.getWorkQueue().schedule((AbstractWork)new GetThreadDumpWork(this.ccs, tdf.getNode(), (IResultCallback<String>)new IPCResponder(handle, mid)));
                break;
            }
            default: {
                try {
                    handle.send(mid, null, (Exception)new IllegalArgumentException("Unknown function " + fn.getFunctionId()));
                    break;
                }
                catch (IPCException e) {
                    LOGGER.log(Level.WARNING, "Error sending Unknown function response", e);
                }
            }
        }
    }
}

