/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.message.ActiveManagerMessage;
import org.apache.asterix.app.translator.DefaultStatementExecutorFactory;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.dataflow.LSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.management.FeedConnectionRequest;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.FeedCollectOperatorDescriptor;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.asterix.external.operators.FeedIntakeOperatorNodePushable;
import org.apache.asterix.external.operators.FeedMetaOperatorDescriptor;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.lang.aql.statement.SubscribeFeedStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;
import org.apache.asterix.metadata.feeds.LocationConstraint;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.runtime.job.listener.MultiTransactionJobletEventListenerFactory;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.AssignRuntimeFactory;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.constraints.Constraint;
import org.apache.hyracks.api.constraints.PartitionConstraintHelper;
import org.apache.hyracks.api.constraints.expressions.ConstantExpression;
import org.apache.hyracks.api.constraints.expressions.ConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.LValueConstraintExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionCountExpression;
import org.apache.hyracks.api.constraints.expressions.PartitionLocationExpression;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningConnectorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.MToNPartitioningWithMessageConnectorDescriptor;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.file.FileRemoveOperatorDescriptor;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.misc.NullSinkOperatorDescriptor;
import org.apache.hyracks.dataflow.std.misc.ReplicateOperatorDescriptor;

public class FeedOperations {
    private FeedOperations() {
    }

    private static Pair<JobSpecification, IAdapterFactory> buildFeedIntakeJobSpec(Feed feed, MetadataProvider metadataProvider, FeedPolicyAccessor policyAccessor) throws Exception {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        spec.setFrameSize(metadataProvider.getApplicationContext().getCompilerProperties().getFrameSize());
        Triple t = metadataProvider.buildFeedIntakeRuntime(spec, feed, policyAccessor);
        IOperatorDescriptor feedIngestor = (IOperatorDescriptor)t.first;
        AlgebricksPartitionConstraint ingesterPc = (AlgebricksPartitionConstraint)t.second;
        IAdapterFactory adapterFactory = (IAdapterFactory)t.third;
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)feedIngestor, (AlgebricksPartitionConstraint)ingesterPc);
        NullSinkOperatorDescriptor nullSink = new NullSinkOperatorDescriptor((IOperatorDescriptorRegistry)spec);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)nullSink, (AlgebricksPartitionConstraint)ingesterPc);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), feedIngestor, 0, (IOperatorDescriptor)nullSink, 0);
        spec.addRoot((IOperatorDescriptor)nullSink);
        return Pair.of((Object)spec, (Object)adapterFactory);
    }

    public static JobSpecification buildRemoveFeedStorageJob(MetadataProvider metadataProvider, Feed feed) throws AsterixException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        AlgebricksAbsolutePartitionConstraint allCluster = ClusterStateManager.INSTANCE.getClusterLocations();
        TreeSet<String> nodes = new TreeSet<String>();
        for (String node : allCluster.getLocations()) {
            nodes.add(node);
        }
        AlgebricksAbsolutePartitionConstraint locations = new AlgebricksAbsolutePartitionConstraint(nodes.toArray(new String[nodes.size()]));
        FileSplit[] feedLogFileSplits = FeedUtils.splitsForAdapter((String)feed.getDataverseName(), (String)feed.getFeedName(), (AlgebricksPartitionConstraint)locations);
        org.apache.hyracks.algebricks.common.utils.Pair spC = StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])feedLogFileSplits);
        FileRemoveOperatorDescriptor frod = new FileRemoveOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IFileSplitProvider)spC.first, true);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)frod, (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)spC.second));
        spec.addRoot((IOperatorDescriptor)frod);
        return spec;
    }

    private static JobSpecification getConnectionJob(SessionOutput sessionOutput, MetadataProvider metadataProvider, FeedConnection feedConnection, String[] locations, ILangCompilationProvider compilationProvider, IStorageComponentProvider storageComponentProvider, DefaultStatementExecutorFactory qtFactory, IHyracksClientConnection hcc) throws AlgebricksException, RemoteException, ACIDException {
        DataverseDecl dataverseDecl = new DataverseDecl(new Identifier(feedConnection.getDataverseName()));
        FeedConnectionRequest fcr = new FeedConnectionRequest(FeedUtils.FeedRuntimeType.INTAKE, feedConnection.getAppliedFunctions(), feedConnection.getDatasetName(), feedConnection.getPolicyName(), feedConnection.getFeedId());
        SubscribeFeedStatement subscribeStmt = new SubscribeFeedStatement(locations, fcr);
        subscribeStmt.initialize(metadataProvider.getMetadataTxnContext());
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add((Statement)dataverseDecl);
        statements.add((Statement)subscribeStmt);
        IStatementExecutor translator = qtFactory.create(metadataProvider.getApplicationContext(), statements, sessionOutput, compilationProvider, storageComponentProvider);
        metadataProvider.getConfig().put("import-private-functions", "" + Boolean.TRUE);
        metadataProvider.getConfig().put("feed-policy-name", "" + subscribeStmt.getPolicy());
        metadataProvider.getConfig().put("collect-locations", StringUtils.join((Object[])subscribeStmt.getLocations(), (char)','));
        CompiledStatements.CompiledSubscribeFeedStatement csfs = new CompiledStatements.CompiledSubscribeFeedStatement(subscribeStmt.getSubscriptionRequest(), subscribeStmt.getVarCounter());
        return translator.rewriteCompileQuery((IClusterInfoCollector)hcc, metadataProvider, subscribeStmt.getQuery(), (CompiledStatements.ICompiledDmlStatement)csfs);
    }

    private static JobSpecification combineIntakeCollectJobs(MetadataProvider metadataProvider, Feed feed, JobSpecification intakeJob, List<JobSpecification> jobsList, List<FeedConnection> feedConnections, String[] intakeLocations) throws AlgebricksException, HyracksDataException {
        JobSpecification jobSpec = new JobSpecification(intakeJob.getFrameSize());
        FeedIntakeOperatorDescriptor firstOp = (FeedIntakeOperatorDescriptor)intakeJob.getOperatorMap().get(new OperatorDescriptorId(0));
        FeedIntakeOperatorDescriptor ingestionOp = firstOp.getAdaptorFactory() == null ? new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, firstOp.getAdaptorLibraryName(), firstOp.getAdaptorFactoryClassName(), firstOp.getAdapterOutputType(), firstOp.getPolicyAccessor(), firstOp.getOutputRecordDescriptors()[0]) : new FeedIntakeOperatorDescriptor(jobSpec, (IFeed)feed, firstOp.getAdaptorFactory(), firstOp.getAdapterOutputType(), firstOp.getPolicyAccessor(), firstOp.getOutputRecordDescriptors()[0]);
        ReplicateOperatorDescriptor replicateOp = new ReplicateOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, ingestionOp.getOutputRecordDescriptors()[0], jobsList.size());
        jobSpec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)jobSpec), (IOperatorDescriptor)ingestionOp, 0, (IOperatorDescriptor)replicateOp, 0);
        PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)ingestionOp, (String[])intakeLocations);
        PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)replicateOp, (String[])intakeLocations);
        HashMap<OperatorDescriptorId, OperatorDescriptorId> operatorIdMapping = new HashMap<OperatorDescriptorId, OperatorDescriptorId>();
        HashMap connectorIdMapping = new HashMap();
        HashMap operatorLocations = new HashMap();
        HashMap operatorCounts = new HashMap();
        ArrayList<JobId> jobIds = new ArrayList<JobId>();
        for (int iter1 = 0; iter1 < jobsList.size(); ++iter1) {
            OperatorDescriptorId opId;
            IOperatorDescriptor opDesc;
            FeedConnection curFeedConnection = feedConnections.get(iter1);
            JobSpecification subJob = jobsList.get(iter1);
            operatorIdMapping.clear();
            Map operatorsMap = subJob.getOperatorMap();
            String datasetName = feedConnections.get(iter1).getDatasetName();
            FeedConnectionId feedConnectionId = new FeedConnectionId(ingestionOp.getEntityId(), datasetName);
            FeedPolicyEntity feedPolicyEntity = FeedMetadataUtil.validateIfPolicyExists((String)curFeedConnection.getDataverseName(), (String)curFeedConnection.getPolicyName(), (MetadataTransactionContext)metadataProvider.getMetadataTxnContext());
            for (Map.Entry entry : operatorsMap.entrySet()) {
                FeedMetaOperatorDescriptor metaOp;
                opDesc = (IOperatorDescriptor)entry.getValue();
                OperatorDescriptorId oldId = opDesc.getOperatorId();
                opId = null;
                if (opDesc instanceof LSMTreeInsertDeleteOperatorDescriptor && ((LSMTreeInsertDeleteOperatorDescriptor)opDesc).isPrimary()) {
                    metaOp = new FeedMetaOperatorDescriptor(jobSpec, feedConnectionId, opDesc, feedPolicyEntity.getProperties(), FeedUtils.FeedRuntimeType.STORE);
                    opId = metaOp.getOperatorId();
                    opDesc.setOperatorId(opId);
                } else {
                    IConnectorDescriptor connectorDesc;
                    AlgebricksMetaOperatorDescriptor algOp;
                    IPushRuntimeFactory[] runtimeFactories;
                    if (opDesc instanceof AlgebricksMetaOperatorDescriptor && (runtimeFactories = (algOp = (AlgebricksMetaOperatorDescriptor)opDesc).getPipeline().getRuntimeFactories())[0] instanceof AssignRuntimeFactory && runtimeFactories.length > 1 && (connectorDesc = (IConnectorDescriptor)((List)subJob.getOperatorInputMap().get(opDesc.getOperatorId())).get(0)) instanceof MToNPartitioningConnectorDescriptor) {
                        metaOp = new FeedMetaOperatorDescriptor(jobSpec, feedConnectionId, opDesc, feedPolicyEntity.getProperties(), FeedUtils.FeedRuntimeType.COMPUTE);
                        opId = metaOp.getOperatorId();
                        opDesc.setOperatorId(opId);
                    }
                    if (opId == null) {
                        opId = jobSpec.createOperatorDescriptorId(opDesc);
                    }
                }
                operatorIdMapping.put(oldId, opId);
            }
            connectorIdMapping.clear();
            for (Map.Entry entry : subJob.getConnectorMap().entrySet()) {
                ConnectorDescriptorId newConnId;
                IConnectorDescriptor connDesc = (IConnectorDescriptor)entry.getValue();
                if (connDesc instanceof MToNPartitioningConnectorDescriptor) {
                    MToNPartitioningConnectorDescriptor m2nConn = (MToNPartitioningConnectorDescriptor)connDesc;
                    connDesc = new MToNPartitioningWithMessageConnectorDescriptor((IConnectorDescriptorRegistry)jobSpec, m2nConn.getTuplePartitionComputerFactory());
                    newConnId = connDesc.getConnectorId();
                } else {
                    newConnId = jobSpec.createConnectorDescriptor(connDesc);
                }
                connectorIdMapping.put(entry.getKey(), newConnId);
            }
            for (Map.Entry entry : subJob.getConnectorOperatorMap().entrySet()) {
                ConnectorDescriptorId newId = (ConnectorDescriptorId)connectorIdMapping.get(entry.getKey());
                IConnectorDescriptor connDesc = (IConnectorDescriptor)jobSpec.getConnectorMap().get(newId);
                Pair leftOp = (Pair)((Pair)entry.getValue()).getLeft();
                Pair rightOp = (Pair)((Pair)entry.getValue()).getRight();
                IOperatorDescriptor leftOpDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(((IOperatorDescriptor)leftOp.getLeft()).getOperatorId());
                IOperatorDescriptor rightOpDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(((IOperatorDescriptor)rightOp.getLeft()).getOperatorId());
                if (leftOp.getLeft() instanceof FeedCollectOperatorDescriptor) {
                    jobSpec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)jobSpec), (IOperatorDescriptor)replicateOp, iter1, leftOpDesc, ((Integer)leftOp.getRight()).intValue());
                }
                jobSpec.connect(connDesc, leftOpDesc, ((Integer)leftOp.getRight()).intValue(), rightOpDesc, ((Integer)rightOp.getRight()).intValue());
            }
            operatorLocations.clear();
            operatorCounts.clear();
            for (Constraint constraint : subJob.getUserConstraints()) {
                LValueConstraintExpression lexpr = constraint.getLValue();
                ConstraintExpression cexpr = constraint.getRValue();
                switch (lexpr.getTag()) {
                    case PARTITION_COUNT: {
                        opId = ((PartitionCountExpression)lexpr).getOperatorDescriptorId();
                        operatorCounts.put(operatorIdMapping.get(opId), (Integer)((ConstantExpression)cexpr).getValue());
                        break;
                    }
                    case PARTITION_LOCATION: {
                        opId = ((PartitionLocationExpression)lexpr).getOperatorDescriptorId();
                        IOperatorDescriptor opDesc2 = (IOperatorDescriptor)jobSpec.getOperatorMap().get(operatorIdMapping.get(opId));
                        ArrayList<LocationConstraint> locations = (ArrayList<LocationConstraint>)operatorLocations.get(opDesc2.getOperatorId());
                        if (locations == null) {
                            locations = new ArrayList<LocationConstraint>();
                            operatorLocations.put(opDesc2.getOperatorId(), locations);
                        }
                        String location = (String)((ConstantExpression)cexpr).getValue();
                        LocationConstraint lc = new LocationConstraint(location, ((PartitionLocationExpression)lexpr).getPartition());
                        locations.add(lc);
                        break;
                    }
                }
            }
            for (Map.Entry entry : operatorLocations.entrySet()) {
                opDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(entry.getKey());
                Collections.sort((List)entry.getValue(), (o1, o2) -> o1.partition - o2.partition);
                String[] locations = new String[((List)entry.getValue()).size()];
                for (int j = 0; j < locations.length; ++j) {
                    locations[j] = ((LocationConstraint)((List)entry.getValue()).get((int)j)).location;
                }
                PartitionConstraintHelper.addAbsoluteLocationConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (String[])locations);
            }
            for (Map.Entry entry : operatorCounts.entrySet()) {
                opDesc = (IOperatorDescriptor)jobSpec.getOperatorMap().get(entry.getKey());
                if (operatorLocations.keySet().contains(entry.getKey())) continue;
                PartitionConstraintHelper.addPartitionCountConstraint((JobSpecification)jobSpec, (IOperatorDescriptor)opDesc, (int)((Integer)entry.getValue()));
            }
            for (OperatorDescriptorId root : subJob.getRoots()) {
                jobSpec.addRoot((IOperatorDescriptor)jobSpec.getOperatorMap().get(operatorIdMapping.get(root)));
            }
            jobIds.add(((JobEventListenerFactory)subJob.getJobletEventListenerFactory()).getJobId());
        }
        jobSpec.setJobletEventListenerFactory((IJobletEventListenerFactory)new MultiTransactionJobletEventListenerFactory(jobIds, true));
        jobSpec.setUseConnectorPolicyForScheduling(jobsList.get(0).isUseConnectorPolicyForScheduling());
        jobSpec.setConnectorPolicyAssignmentPolicy(jobsList.get(0).getConnectorPolicyAssignmentPolicy());
        return jobSpec;
    }

    public static Pair<JobSpecification, AlgebricksAbsolutePartitionConstraint> buildStartFeedJob(SessionOutput sessionOutput, MetadataProvider metadataProvider, Feed feed, List<FeedConnection> feedConnections, ILangCompilationProvider compilationProvider, IStorageComponentProvider storageComponentProvider, DefaultStatementExecutorFactory qtFactory, IHyracksClientConnection hcc) throws Exception {
        FeedPolicyAccessor fpa = new FeedPolicyAccessor(new HashMap());
        Pair<JobSpecification, IAdapterFactory> intakeInfo = FeedOperations.buildFeedIntakeJobSpec(feed, metadataProvider, fpa);
        ArrayList<JobSpecification> jobsList = new ArrayList<JobSpecification>();
        JobSpecification intakeJob = (JobSpecification)intakeInfo.getLeft();
        IAdapterFactory ingestionAdaptorFactory = (IAdapterFactory)intakeInfo.getRight();
        String[] ingestionLocations = ingestionAdaptorFactory.getPartitionConstraint().getLocations();
        for (FeedConnection feedConnection : feedConnections) {
            JobSpecification connectionJob = FeedOperations.getConnectionJob(sessionOutput, metadataProvider, feedConnection, ingestionLocations, compilationProvider, storageComponentProvider, qtFactory, hcc);
            jobsList.add(connectionJob);
        }
        return Pair.of((Object)FeedOperations.combineIntakeCollectJobs(metadataProvider, feed, intakeJob, jobsList, feedConnections, ingestionLocations), (Object)((IAdapterFactory)intakeInfo.getRight()).getPartitionConstraint());
    }

    public static void SendStopMessageToNode(ICcApplicationContext appCtx, EntityId feedId, String intakeNodeLocation, Integer partition) throws Exception {
        ActiveManagerMessage stopFeedMessage = new ActiveManagerMessage(0, (Serializable)new ActiveRuntimeId(feedId, FeedIntakeOperatorNodePushable.class.getSimpleName(), partition.intValue()));
        FeedOperations.SendActiveMessage(appCtx, stopFeedMessage, intakeNodeLocation);
    }

    private static void SendActiveMessage(ICcApplicationContext appCtx, ActiveManagerMessage activeManagerMessage, String nodeId) throws Exception {
        ICCMessageBroker messageBroker = (ICCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        messageBroker.sendApplicationMessageToNC((INcAddressedMessage)activeManagerMessage, nodeId);
    }
}

