/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.nc.NodeControllerService;

public class NCMessageBroker
implements INCMessageBroker {
    private static final Logger LOGGER = Logger.getLogger(NCMessageBroker.class.getName());
    private final NodeControllerService ncs;
    private final INcApplicationContext appContext;
    private final LinkedBlockingQueue<INcAddressedMessage> receivedMsgsQ;
    private final ConcurrentFramePool messagingFramePool;
    private final int maxMsgSize;
    private final AtomicLong futureIdGenerator;
    private final LongObjectMap<MessageFuture> futureMap;

    public NCMessageBroker(NodeControllerService ncs, MessagingProperties messagingProperties) {
        this.ncs = ncs;
        this.appContext = (INcApplicationContext)ncs.getApplicationContext();
        this.maxMsgSize = messagingProperties.getFrameSize();
        int messagingMemoryBudget = messagingProperties.getFrameSize() * messagingProperties.getFrameCount();
        this.messagingFramePool = new ConcurrentFramePool(ncs.getId(), (long)messagingMemoryBudget, messagingProperties.getFrameSize());
        this.receivedMsgsQ = new LinkedBlockingQueue();
        this.futureIdGenerator = new AtomicLong();
        this.futureMap = new LongObjectHashMap();
        MessageDeliveryService msgDeliverySvc = new MessageDeliveryService();
        this.appContext.getThreadExecutor().execute(msgDeliverySvc);
    }

    public void sendMessageToCC(ICcAddressedMessage message) throws Exception {
        this.ncs.sendApplicationMessageToCC(JavaSerializationUtils.serialize((Serializable)message), null);
    }

    public void sendMessageToNC(String nodeId, INcAddressedMessage message) throws Exception {
        IChannelControlBlock messagingChannel = this.ncs.getMessagingNetworkManager().getMessagingChannel(nodeId);
        this.sendMessageToChannel(messagingChannel, message);
    }

    public void queueReceivedMessage(INcAddressedMessage msg) {
        this.receivedMsgsQ.offer(msg);
    }

    public void receivedMessage(IMessage message, String nodeId) throws Exception {
        INcAddressedMessage absMessage = (INcAddressedMessage)message;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Received message: " + absMessage);
        }
        absMessage.handle(this.appContext);
    }

    public ConcurrentFramePool getMessagingFramePool() {
        return this.messagingFramePool;
    }

    private void sendMessageToChannel(IChannelControlBlock ccb, INcAddressedMessage msg) throws IOException {
        byte[] serializedMsg = JavaSerializationUtils.serialize((Serializable)msg);
        if (serializedMsg.length > this.maxMsgSize) {
            throw new HyracksDataException("Message exceded maximum size");
        }
        ByteBuffer msgBuffer = this.messagingFramePool.get();
        if (msgBuffer == null) {
            throw new HyracksDataException("Could not get an empty buffer");
        }
        msgBuffer.clear();
        msgBuffer.put(serializedMsg);
        msgBuffer.flip();
        ccb.getWriteInterface().getFullBufferAcceptor().accept(msgBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFuture registerMessageFuture() {
        long futureId = this.futureIdGenerator.incrementAndGet();
        MessageFuture future = new MessageFuture(futureId);
        LongObjectMap<MessageFuture> longObjectMap = this.futureMap;
        synchronized (longObjectMap) {
            if (this.futureMap.containsKey(futureId)) {
                throw new IllegalStateException();
            }
            this.futureMap.put(futureId, (Object)future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFuture deregisterMessageFuture(long futureId) {
        LongObjectMap<MessageFuture> longObjectMap = this.futureMap;
        synchronized (longObjectMap) {
            return (MessageFuture)this.futureMap.remove(futureId);
        }
    }

    private class MessageDeliveryService
    implements Runnable {
        private MessageDeliveryService() {
        }

        @Override
        public void run() {
            while (true) {
                INcAddressedMessage msg = null;
                try {
                    msg = (INcAddressedMessage)NCMessageBroker.this.receivedMsgsQ.take();
                    NCMessageBroker.this.receivedMessage((IMessage)msg, null);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.WARNING) && msg != null) {
                        LOGGER.log(Level.WARNING, "Could not process message : " + msg, e);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "Could not process message", e);
                    continue;
                }
                break;
            }
        }
    }
}

