/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.metadata.cluster.AddNodeWork;
import org.apache.asterix.metadata.cluster.ClusterManagerProvider;
import org.apache.asterix.metadata.cluster.RemoveNodeWork;
import org.apache.asterix.runtime.utils.ClusterStateManager;

public class ClusterWorkExecutor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ClusterWorkExecutor.class.getName());
    private final ICcApplicationContext appCtx;
    private final LinkedBlockingQueue<Set<IClusterManagementWork>> inbox;

    public ClusterWorkExecutor(ICcApplicationContext appCtx, LinkedBlockingQueue<Set<IClusterManagementWork>> inbox) {
        this.appCtx = appCtx;
        this.inbox = inbox;
    }

    @Override
    public void run() {
        while (true) {
            try {
                block10: while (true) {
                    Set<IClusterManagementWork> workSet = this.inbox.take();
                    int nodesToAdd = 0;
                    HashSet nodesToRemove = new HashSet();
                    HashSet<IClusterManagementWork> nodeAdditionRequests = new HashSet<IClusterManagementWork>();
                    HashSet<IClusterManagementWork> nodeRemovalRequests = new HashSet<IClusterManagementWork>();
                    for (IClusterManagementWork w : workSet) {
                        switch (w.getClusterManagementWorkType()) {
                            case ADD_NODE: {
                                if (nodesToAdd < ((AddNodeWork)w).getNumberOfNodesRequested()) {
                                    nodesToAdd = ((AddNodeWork)w).getNumberOfNodesRequested();
                                }
                                nodeAdditionRequests.add(w);
                                break;
                            }
                            case REMOVE_NODE: {
                                nodesToRemove.addAll(((RemoveNodeWork)w).getNodesToBeRemoved());
                                nodeRemovalRequests.add(w);
                            }
                        }
                    }
                    HashSet<Node> addedNodes = new HashSet<Node>();
                    int i = 0;
                    while (true) {
                        if (i >= nodesToAdd) continue block10;
                        Node node = ClusterStateManager.INSTANCE.getAvailableSubstitutionNode();
                        if (node != null) {
                            try {
                                ClusterManagerProvider.getClusterManager().addNode(this.appCtx, node);
                                addedNodes.add(node);
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.info("Added NC at:" + node.getId());
                                }
                            }
                            catch (AsterixException e) {
                                if (LOGGER.isLoggable(Level.WARNING)) {
                                    LOGGER.warning("Unable to add NC at:" + node.getId());
                                }
                                e.printStackTrace();
                            }
                        } else if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("Unable to add NC: no more available nodes");
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("interruped" + e.getMessage());
                }
                throw new IllegalStateException(e);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.severe("Unexpected exception in handling cluster event" + e.getMessage());
                continue;
            }
            break;
        }
    }
}

