/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.app.replication.message.ReplayPartitionLogsResponseMessage;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.nc.NodeControllerService;

public class ReplayPartitionLogsRequestMessage
implements INCLifecycleMessage,
INcAddressedMessage {
    private static final Logger LOGGER = Logger.getLogger(ReplayPartitionLogsRequestMessage.class.getName());
    private static final long serialVersionUID = 1L;
    private final Set<Integer> partitions;

    public ReplayPartitionLogsRequestMessage(Set<Integer> partitions) {
        this.partitions = partitions;
    }

    public void handle(INcApplicationContext appContext) throws HyracksDataException, InterruptedException {
        NodeControllerService ncs = (NodeControllerService)appContext.getServiceContext().getControllerService();
        appContext.getRemoteRecoveryManager().replayReplicaPartitionLogs(this.partitions, true);
        INCMessageBroker broker = (INCMessageBroker)ncs.getContext().getMessageBroker();
        ReplayPartitionLogsResponseMessage reponse = new ReplayPartitionLogsResponseMessage(ncs.getId(), this.partitions);
        try {
            broker.sendMessageToCC((ICcAddressedMessage)reponse);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed sending message to cc", e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.REPLAY_LOGS_REQUEST;
    }
}

