/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import java.rmi.RemoteException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.app.replication.message.PreparePartitionsFailbackResponseMessage;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.runtime.message.AbstractFailbackPlanMessage;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PreparePartitionsFailbackRequestMessage
extends AbstractFailbackPlanMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PreparePartitionsFailbackRequestMessage.class.getName());
    private final Set<Integer> partitions;
    private boolean releaseMetadataNode = false;
    private final String nodeID;

    public PreparePartitionsFailbackRequestMessage(long planId, int requestId, String nodeId, Set<Integer> partitions) {
        super(planId, requestId);
        this.nodeID = nodeId;
        this.partitions = partitions;
    }

    public Set<Integer> getPartitions() {
        return this.partitions;
    }

    public boolean isReleaseMetadataNode() {
        return this.releaseMetadataNode;
    }

    public void setReleaseMetadataNode(boolean releaseMetadataNode) {
        this.releaseMetadataNode = releaseMetadataNode;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PreparePartitionsFailbackRequestMessage.class.getSimpleName());
        sb.append(" Plan ID: " + this.planId);
        sb.append(" Partitions: " + this.partitions);
        sb.append(" releaseMetadataNode: " + this.releaseMetadataNode);
        return sb.toString();
    }

    public void handle(INcApplicationContext appContext) throws HyracksDataException, InterruptedException {
        INCMessageBroker broker = (INCMessageBroker)appContext.getServiceContext().getMessageBroker();
        if (this.releaseMetadataNode) {
            appContext.getDatasetLifecycleManager().closeAllDatasets();
            try {
                appContext.unexportMetadataNodeStub();
            }
            catch (RemoteException e) {
                LOGGER.log(Level.SEVERE, "Failed unexporting metadata stub", e);
                throw HyracksDataException.create((Throwable)e);
            }
        } else {
            appContext.getDatasetLifecycleManager().closeUserDatasets();
            appContext.getDatasetLifecycleManager().flushAllDatasets();
        }
        PersistentLocalResourceRepository localResourceRepo = (PersistentLocalResourceRepository)appContext.getLocalResourceRepository();
        for (Integer partitionId : this.partitions) {
            localResourceRepo.addInactivePartition(partitionId.intValue());
        }
        PreparePartitionsFailbackResponseMessage reponse = new PreparePartitionsFailbackResponseMessage(this.planId, this.requestId, this.partitions);
        try {
            broker.sendMessageToCC((ICcAddressedMessage)reponse);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed sending message to cc", e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.PREPARE_FAILBACK_REQUEST;
    }
}

