/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.app.replication.message.CompleteFailbackResponseMessage;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.replication.IRemoteRecoveryManager;
import org.apache.asterix.runtime.message.AbstractFailbackPlanMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class CompleteFailbackRequestMessage
extends AbstractFailbackPlanMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CompleteFailbackRequestMessage.class.getName());
    private final Set<Integer> partitions;
    private final String nodeId;

    public CompleteFailbackRequestMessage(long planId, int requestId, String nodeId, Set<Integer> partitions) {
        super(planId, requestId);
        this.nodeId = nodeId;
        this.partitions = partitions;
    }

    public Set<Integer> getPartitions() {
        return this.partitions;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompleteFailbackRequestMessage.class.getSimpleName());
        sb.append(" Plan ID: " + this.planId);
        sb.append(" Node ID: " + this.nodeId);
        sb.append(" Partitions: " + this.partitions);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(INcApplicationContext appContext) throws HyracksDataException, InterruptedException {
        INCMessageBroker broker = (INCMessageBroker)appContext.getServiceContext().getMessageBroker();
        HyracksDataException hde = null;
        try {
            IRemoteRecoveryManager remoteRecoeryManager = appContext.getRemoteRecoveryManager();
            remoteRecoeryManager.completeFailbackProcess();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Failure during completion of failback process", e);
            hde = HyracksDataException.create((Throwable)e);
        }
        finally {
            CompleteFailbackResponseMessage reponse = new CompleteFailbackResponseMessage(this.planId, this.requestId, this.partitions);
            try {
                broker.sendMessageToCC((ICcAddressedMessage)reponse);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failure sending message to CC", e);
                hde = HyracksDataException.suppress((HyracksDataException)hde, (Throwable)e);
            }
        }
        if (hde != null) {
            throw hde;
        }
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.COMPLETE_FAILBACK_REQUEST;
    }
}

