/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.asterix.app.nc.task.BindMetadataNodeTask;
import org.apache.asterix.app.nc.task.CheckpointTask;
import org.apache.asterix.app.nc.task.ExternalLibrarySetupTask;
import org.apache.asterix.app.nc.task.LocalRecoveryTask;
import org.apache.asterix.app.nc.task.MetadataBootstrapTask;
import org.apache.asterix.app.nc.task.ReportMaxResourceIdTask;
import org.apache.asterix.app.nc.task.StartLifecycleComponentsTask;
import org.apache.asterix.app.replication.message.NCLifecycleTaskReportMessage;
import org.apache.asterix.app.replication.message.StartupTaskRequestMessage;
import org.apache.asterix.app.replication.message.StartupTaskResponseMessage;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.IFaultToleranceStrategy;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class NoFaultToleranceStrategy
implements IFaultToleranceStrategy {
    private static final Logger LOGGER = Logger.getLogger(NoFaultToleranceStrategy.class.getName());
    IClusterStateManager clusterManager;
    private String metadataNodeId;
    private Set<String> pendingStartupCompletionNodes = new HashSet<String>();
    private ICCMessageBroker messageBroker;

    public void notifyNodeJoin(String nodeId) throws HyracksDataException {
        this.pendingStartupCompletionNodes.add(nodeId);
    }

    public void notifyNodeFailure(String nodeId) throws HyracksDataException {
        this.pendingStartupCompletionNodes.remove(nodeId);
        this.clusterManager.updateNodePartitions(nodeId, false);
        if (nodeId.equals(this.metadataNodeId)) {
            this.clusterManager.updateMetadataNode(this.metadataNodeId, false);
        }
        this.clusterManager.refreshState();
    }

    public void process(INCLifecycleMessage message) throws HyracksDataException {
        switch (message.getType()) {
            case STARTUP_TASK_REQUEST: {
                this.process((StartupTaskRequestMessage)message);
                break;
            }
            case STARTUP_TASK_RESULT: {
                this.process((NCLifecycleTaskReportMessage)message);
                break;
            }
            default: {
                throw new RuntimeDataException(4003, new Serializable[]{message.getType().name()});
            }
        }
    }

    public IFaultToleranceStrategy from(ICCServiceContext serviceCtx, IReplicationStrategy replicationStrategy) {
        NoFaultToleranceStrategy ft = new NoFaultToleranceStrategy();
        ft.messageBroker = (ICCMessageBroker)serviceCtx.getMessageBroker();
        return ft;
    }

    public void bindTo(IClusterStateManager clusterManager) {
        this.clusterManager = clusterManager;
        this.metadataNodeId = clusterManager.getCurrentMetadataNodeId();
    }

    private void process(StartupTaskRequestMessage msg) throws HyracksDataException {
        String nodeId = msg.getNodeId();
        List<INCLifecycleTask> tasks = this.buildNCStartupSequence(msg.getNodeId(), msg.getState());
        StartupTaskResponseMessage response = new StartupTaskResponseMessage(nodeId, tasks);
        try {
            this.messageBroker.sendApplicationMessageToNC((INcAddressedMessage)response, msg.getNodeId());
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void process(NCLifecycleTaskReportMessage msg) throws HyracksDataException {
        this.pendingStartupCompletionNodes.remove(msg.getNodeId());
        if (msg.isSuccess()) {
            this.clusterManager.updateNodePartitions(msg.getNodeId(), true);
            if (msg.getNodeId().equals(this.metadataNodeId)) {
                this.clusterManager.updateMetadataNode(this.metadataNodeId, true);
            }
            this.clusterManager.refreshState();
        } else if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, msg.getNodeId() + " failed to complete startup. ", msg.getException());
        }
    }

    private List<INCLifecycleTask> buildNCStartupSequence(String nodeId, IRecoveryManager.SystemState state) {
        boolean isMetadataNode;
        ArrayList<INCLifecycleTask> tasks = new ArrayList<INCLifecycleTask>();
        if (state == IRecoveryManager.SystemState.CORRUPTED) {
            LocalRecoveryTask rt = new LocalRecoveryTask(Arrays.asList(this.clusterManager.getNodePartitions(nodeId)).stream().map(ClusterPartition::getPartitionId).collect(Collectors.toSet()));
            tasks.add(rt);
        }
        if (isMetadataNode = nodeId.equals(this.metadataNodeId)) {
            tasks.add(new MetadataBootstrapTask());
        }
        tasks.add(new ExternalLibrarySetupTask(isMetadataNode));
        tasks.add(new ReportMaxResourceIdTask());
        tasks.add(new CheckpointTask());
        tasks.add(new StartLifecycleComponentsTask());
        if (isMetadataNode) {
            tasks.add(new BindMetadataNodeTask(true));
        }
        return tasks;
    }
}

