/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.asterix.common.replication.IReplicaResourcesManager;
import org.apache.asterix.common.transactions.Checkpoint;
import org.apache.asterix.common.transactions.IAppRuntimeContextProvider;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILogReader;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.asterix.transaction.management.service.logging.LogManager;
import org.apache.asterix.transaction.management.service.recovery.TxnId;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.LocalResource;

public class RecoveryManager
implements IRecoveryManager,
ILifeCycleComponent {
    public static final boolean IS_DEBUG_MODE = false;
    private static final Logger LOGGER = Logger.getLogger(RecoveryManager.class.getName());
    private final ITransactionSubsystem txnSubsystem;
    private final LogManager logMgr;
    private final boolean replicationEnabled;
    private static final String RECOVERY_FILES_DIR_NAME = "recovery_temp";
    private Map<Integer, JobEntityCommits> jobId2WinnerEntitiesMap = null;
    private final long cachedEntityCommitsPerJobSize;
    private final PersistentLocalResourceRepository localResourceRepository;
    private final ICheckpointManager checkpointManager;
    private IRecoveryManager.SystemState state;
    private final INCServiceContext serviceCtx;

    public RecoveryManager(ITransactionSubsystem txnSubsystem, INCServiceContext serviceCtx) {
        this.serviceCtx = serviceCtx;
        this.txnSubsystem = txnSubsystem;
        this.logMgr = (LogManager)txnSubsystem.getLogManager();
        ReplicationProperties repProperties = txnSubsystem.getAsterixAppRuntimeContextProvider().getAppContext().getReplicationProperties();
        this.replicationEnabled = repProperties.isParticipant(txnSubsystem.getId());
        this.localResourceRepository = (PersistentLocalResourceRepository)txnSubsystem.getAsterixAppRuntimeContextProvider().getLocalResourceRepository();
        this.cachedEntityCommitsPerJobSize = txnSubsystem.getTransactionProperties().getJobRecoveryMemorySize();
        this.checkpointManager = txnSubsystem.getCheckpointManager();
    }

    public IRecoveryManager.SystemState getSystemState() throws ACIDException {
        Checkpoint checkpointObject = this.checkpointManager.getLatest();
        if (checkpointObject == null) {
            this.state = IRecoveryManager.SystemState.PERMANENT_DATA_LOSS;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("The checkpoint file doesn't exist: systemState = PERMANENT_DATA_LOSS");
            }
            return this.state;
        }
        if (this.replicationEnabled) {
            this.state = checkpointObject.getMinMCTFirstLsn() == -1L ? IRecoveryManager.SystemState.HEALTHY : (checkpointObject.getCheckpointLsn() == this.logMgr.getAppendLSN() && checkpointObject.isSharp() ? IRecoveryManager.SystemState.HEALTHY : IRecoveryManager.SystemState.CORRUPTED);
        } else {
            long readableSmallestLSN = this.logMgr.getReadableSmallestLSN();
            if (this.logMgr.getAppendLSN() == readableSmallestLSN) {
                if (checkpointObject.getMinMCTFirstLsn() != -1L) {
                    LOGGER.warning("Some(or all) of transaction log files are lost.");
                }
                this.state = IRecoveryManager.SystemState.HEALTHY;
            } else {
                this.state = checkpointObject.getCheckpointLsn() == this.logMgr.getAppendLSN() && checkpointObject.getMinMCTFirstLsn() == -1L ? IRecoveryManager.SystemState.HEALTHY : IRecoveryManager.SystemState.CORRUPTED;
            }
        }
        return this.state;
    }

    public void startLocalRecovery(Set<Integer> partitions) throws IOException, ACIDException {
        this.state = IRecoveryManager.SystemState.RECOVERING;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("starting recovery ...");
        }
        long readableSmallestLSN = this.logMgr.getReadableSmallestLSN();
        Checkpoint checkpointObject = this.checkpointManager.getLatest();
        long lowWaterMarkLSN = checkpointObject.getMinMCTFirstLsn();
        if (lowWaterMarkLSN < readableSmallestLSN) {
            lowWaterMarkLSN = readableSmallestLSN;
        }
        this.deleteRecoveryTemporaryFiles();
        this.replayPartitionsLogs(partitions, this.logMgr.getLogReader(true), lowWaterMarkLSN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replayPartitionsLogs(Set<Integer> partitions, ILogReader logReader, long lowWaterMarkLSN) throws IOException, ACIDException {
        try {
            Set<Integer> winnerJobSet = this.startRecoverysAnalysisPhase(partitions, logReader, lowWaterMarkLSN);
            this.startRecoveryRedoPhase(partitions, logReader, lowWaterMarkLSN, winnerJobSet);
        }
        finally {
            logReader.close();
            this.deleteRecoveryTemporaryFiles();
        }
    }

    private synchronized Set<Integer> startRecoverysAnalysisPhase(Set<Integer> partitions, ILogReader logReader, long lowWaterMarkLSN) throws IOException, ACIDException {
        int updateLogCount = 0;
        int entityCommitLogCount = 0;
        int jobCommitLogCount = 0;
        int abortLogCount = 0;
        HashSet<Integer> winnerJobSet = new HashSet<Integer>();
        this.jobId2WinnerEntitiesMap = new HashMap<Integer, JobEntityCommits>();
        logReader.initializeScan(lowWaterMarkLSN);
        ILogRecord logRecord = logReader.next();
        while (logRecord != null) {
            switch (logRecord.getLogType()) {
                case 0: {
                    if (!partitions.contains(logRecord.getResourcePartition())) break;
                    ++updateLogCount;
                    break;
                }
                case 1: {
                    winnerJobSet.add(logRecord.getJobId());
                    this.cleanupJobCommits(logRecord.getJobId());
                    ++jobCommitLogCount;
                    break;
                }
                case 2: {
                    if (!partitions.contains(logRecord.getResourcePartition())) break;
                    this.analyzeEntityCommitLog(logRecord);
                    ++entityCommitLogCount;
                    break;
                }
                case 3: {
                    ++abortLogCount;
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new ACIDException("Unsupported LogType: " + logRecord.getLogType());
                }
            }
            logRecord = logReader.next();
        }
        for (JobEntityCommits winners : this.jobId2WinnerEntitiesMap.values()) {
            winners.prepareForSearch();
        }
        LOGGER.info("Logs analysis phase completed.");
        LOGGER.info("Analysis log count update/entityCommit/jobCommit/abort = " + updateLogCount + "/" + entityCommitLogCount + "/" + jobCommitLogCount + "/" + abortLogCount);
        return winnerJobSet;
    }

    private void cleanupJobCommits(int jobId) {
        if (this.jobId2WinnerEntitiesMap.containsKey(jobId)) {
            JobEntityCommits jobEntityWinners = this.jobId2WinnerEntitiesMap.get(jobId);
            jobEntityWinners.clear();
            this.jobId2WinnerEntitiesMap.remove(jobId);
        }
    }

    private void analyzeEntityCommitLog(ILogRecord logRecord) throws IOException {
        JobEntityCommits jobEntityWinners;
        int jobId = logRecord.getJobId();
        if (!this.jobId2WinnerEntitiesMap.containsKey(jobId)) {
            jobEntityWinners = new JobEntityCommits(jobId);
            if (this.needToFreeMemory()) {
                this.freeJobsCachedEntities(jobId);
            }
            this.jobId2WinnerEntitiesMap.put(jobId, jobEntityWinners);
        } else {
            jobEntityWinners = this.jobId2WinnerEntitiesMap.get(jobId);
        }
        jobEntityWinners.add(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startRecoveryRedoPhase(Set<Integer> partitions, ILogReader logReader, long lowWaterMarkLSN, Set<Integer> winnerJobSet) throws IOException, ACIDException {
        int redoCount = 0;
        int jobId = -1;
        long lsn = -1L;
        ILSMIndex index = null;
        LocalResource localResource = null;
        DatasetLocalResource localResourceMetadata = null;
        boolean foundWinner = false;
        JobEntityCommits jobEntityWinners = null;
        IAppRuntimeContextProvider appRuntimeContext = this.txnSubsystem.getAsterixAppRuntimeContextProvider();
        IDatasetLifecycleManager datasetLifecycleManager = appRuntimeContext.getDatasetLifecycleManager();
        Map resourcesMap = this.localResourceRepository.loadAndGetAllResources();
        HashMap<Long, Long> resourceId2MaxLSNMap = new HashMap<Long, Long>();
        TxnId tempKeyTxnId = new TxnId(-1, -1, -1, null, -1, false);
        ILogRecord logRecord = null;
        try {
            logReader.initializeScan(lowWaterMarkLSN);
            logRecord = logReader.next();
            block9: while (logRecord != null) {
                lsn = logRecord.getLSN();
                jobId = logRecord.getJobId();
                foundWinner = false;
                switch (logRecord.getLogType()) {
                    case 0: {
                        long maxDiskLastLsn;
                        if (!partitions.contains(logRecord.getResourcePartition())) break;
                        if (winnerJobSet.contains(jobId)) {
                            foundWinner = true;
                        } else if (this.jobId2WinnerEntitiesMap.containsKey(jobId)) {
                            jobEntityWinners = this.jobId2WinnerEntitiesMap.get(jobId);
                            tempKeyTxnId.setTxnId(jobId, logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize());
                            if (jobEntityWinners.containsEntityCommitForTxnId(lsn, tempKeyTxnId)) {
                                foundWinner = true;
                            }
                        }
                        if (!foundWinner) break;
                        long resourceId = logRecord.getResourceId();
                        localResource = (LocalResource)resourcesMap.get(resourceId);
                        if (localResource == null) {
                            LOGGER.log(Level.WARNING, "resource was not found for resource id " + resourceId);
                            logRecord = logReader.next();
                            continue block9;
                        }
                        localResourceMetadata = (DatasetLocalResource)localResource.getResource();
                        index = (ILSMIndex)datasetLifecycleManager.get(localResource.getPath());
                        if (index == null) {
                            index = (ILSMIndex)localResourceMetadata.createInstance(this.serviceCtx);
                            datasetLifecycleManager.register(localResource.getPath(), (Object)index);
                            datasetLifecycleManager.open(localResource.getPath());
                            ILSMIndex lsmIndex = index;
                            try {
                                maxDiskLastLsn = ((AbstractLSMIOOperationCallback)lsmIndex.getIOOperationCallback()).getComponentLSN(lsmIndex.getImmutableComponents());
                            }
                            catch (HyracksDataException e) {
                                datasetLifecycleManager.close(localResource.getPath());
                                throw e;
                            }
                            resourceId2MaxLSNMap.put(resourceId, maxDiskLastLsn);
                        } else {
                            maxDiskLastLsn = (Long)resourceId2MaxLSNMap.get(resourceId);
                        }
                        if (lsn <= maxDiskLastLsn) break;
                        RecoveryManager.redo(logRecord, datasetLifecycleManager);
                        ++redoCount;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    default: {
                        throw new ACIDException("Unsupported LogType: " + logRecord.getLogType());
                    }
                }
                logRecord = logReader.next();
            }
            LOGGER.info("Logs REDO phase completed. Redo logs count: " + redoCount);
        }
        finally {
            Set resourceIdList = resourceId2MaxLSNMap.keySet();
            Iterator iterator = resourceIdList.iterator();
            while (iterator.hasNext()) {
                long r = (Long)iterator.next();
                datasetLifecycleManager.close(((LocalResource)resourcesMap.get(r)).getPath());
            }
        }
    }

    private boolean needToFreeMemory() {
        return Runtime.getRuntime().freeMemory() < this.cachedEntityCommitsPerJobSize;
    }

    public long getMinFirstLSN() throws HyracksDataException {
        long minFirstLSN = this.getLocalMinFirstLSN();
        if (this.replicationEnabled) {
            long remoteMinFirstLSN = this.getRemoteMinFirstLSN();
            minFirstLSN = Math.min(minFirstLSN, remoteMinFirstLSN);
        }
        return minFirstLSN;
    }

    public long getLocalMinFirstLSN() throws HyracksDataException {
        IDatasetLifecycleManager datasetLifecycleManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getDatasetLifecycleManager();
        List openIndexList = datasetLifecycleManager.getOpenResources();
        long minFirstLSN = this.logMgr.getAppendLSN();
        if (!openIndexList.isEmpty()) {
            for (IIndex index : openIndexList) {
                AbstractLSMIOOperationCallback ioCallback = (AbstractLSMIOOperationCallback)((ILSMIndex)index).getIOOperationCallback();
                if (((AbstractLSMIndex)index).isCurrentMutableComponentEmpty() && !ioCallback.hasPendingFlush()) continue;
                long firstLSN = ioCallback.getFirstLSN();
                minFirstLSN = Math.min(minFirstLSN, firstLSN);
            }
        }
        return minFirstLSN;
    }

    private long getRemoteMinFirstLSN() {
        IReplicaResourcesManager remoteResourcesManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getAppContext().getReplicaResourcesManager();
        return remoteResourcesManager.getPartitionsMinLSN(this.localResourceRepository.getInactivePartitions());
    }

    public File createJobRecoveryFile(int jobId, String fileName) throws IOException {
        File jobRecoveryFile;
        String recoveryDirPath = this.getRecoveryDirPath();
        Path jobRecoveryFolder = Paths.get(recoveryDirPath + File.separator + jobId, new String[0]);
        if (!Files.exists(jobRecoveryFolder, new LinkOption[0])) {
            Files.createDirectories(jobRecoveryFolder, new FileAttribute[0]);
        }
        if (!(jobRecoveryFile = new File(jobRecoveryFolder.toString() + File.separator + fileName)).exists()) {
            if (!jobRecoveryFile.createNewFile()) {
                throw new IOException("Failed to create file: " + fileName + " for job id(" + jobId + ")");
            }
        } else {
            throw new IOException("File: " + fileName + " for job id(" + jobId + ") already exists");
        }
        return jobRecoveryFile;
    }

    public void deleteRecoveryTemporaryFiles() {
        String recoveryDirPath = this.getRecoveryDirPath();
        Path recoveryFolderPath = Paths.get(recoveryDirPath, new String[0]);
        FileUtils.deleteQuietly((File)recoveryFolderPath.toFile());
    }

    private String getRecoveryDirPath() {
        String logDir = this.logMgr.getLogManagerProperties().getLogDir();
        if (!logDir.endsWith(File.separator)) {
            logDir = logDir + File.separator;
        }
        return logDir + RECOVERY_FILES_DIR_NAME;
    }

    private void freeJobsCachedEntities(int requestingJobId) throws IOException {
        if (this.jobId2WinnerEntitiesMap != null) {
            for (Map.Entry<Integer, JobEntityCommits> jobEntityCommits : this.jobId2WinnerEntitiesMap.entrySet()) {
                if (jobEntityCommits.getKey() == requestingJobId) continue;
                jobEntityCommits.getValue().spillToDiskAndfreeMemory();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(ITransactionContext txnContext) throws ACIDException {
        int abortedJobId = txnContext.getJobId().getId();
        long firstLSN = txnContext.getFirstLSN();
        try {
            long localMinFirstLSN = this.getLocalMinFirstLSN();
            firstLSN = Math.max(firstLSN, localMinFirstLSN);
        }
        catch (HyracksDataException e) {
            throw new ACIDException((Throwable)e);
        }
        long lastLSN = txnContext.getLastLSN();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("rollbacking transaction log records from " + firstLSN + " to " + lastLSN);
        }
        if (firstLSN == -1L || firstLSN > lastLSN) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("no need to roll back as there were no operations by the job " + txnContext.getJobId());
            }
            return;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("collecting loser transaction's LSNs from " + firstLSN + " to " + lastLSN);
        }
        HashMap<TxnId, LinkedList<Long>> jobLoserEntity2LSNsMap = new HashMap<TxnId, LinkedList<Long>>();
        TxnId tempKeyTxnId = new TxnId(-1, -1, -1, null, -1, false);
        int updateLogCount = 0;
        int entityCommitLogCount = 0;
        int logJobId = -1;
        long currentLSN = -1L;
        TxnId loserEntity = null;
        List<Long> undoLSNSet = null;
        Set activePartitions = this.localResourceRepository.getActivePartitions();
        try (ILogReader logReader = this.logMgr.getLogReader(false);){
            logReader.initializeScan(firstLSN);
            ILogRecord logRecord = null;
            block11: while (currentLSN < lastLSN && (logRecord = logReader.next()) != null) {
                currentLSN = logRecord.getLSN();
                logJobId = logRecord.getJobId();
                if (logJobId != abortedJobId) continue;
                tempKeyTxnId.setTxnId(logJobId, logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize());
                switch (logRecord.getLogType()) {
                    case 0: {
                        if (!activePartitions.contains(logRecord.getResourcePartition())) continue block11;
                        undoLSNSet = (List)jobLoserEntity2LSNsMap.get(tempKeyTxnId);
                        if (undoLSNSet == null) {
                            loserEntity = new TxnId(logJobId, logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize(), true);
                            undoLSNSet = new LinkedList<Long>();
                            jobLoserEntity2LSNsMap.put(loserEntity, (LinkedList<Long>)undoLSNSet);
                        }
                        undoLSNSet.add(currentLSN);
                        ++updateLogCount;
                        continue block11;
                    }
                    case 2: {
                        if (!activePartitions.contains(logRecord.getResourcePartition())) continue block11;
                        jobLoserEntity2LSNsMap.remove(tempKeyTxnId);
                        ++entityCommitLogCount;
                        continue block11;
                    }
                    case 1: {
                        throw new ACIDException("Unexpected LogType(" + logRecord.getLogType() + ") during abort.");
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        continue block11;
                    }
                }
                throw new ACIDException("Unsupported LogType: " + logRecord.getLogType());
            }
            if (currentLSN != lastLSN) {
                throw new ACIDException("LastLSN mismatch: lastLSN(" + lastLSN + ") vs currentLSN(" + currentLSN + ") during abort( " + txnContext.getJobId() + ")");
            }
            LOGGER.log(Level.INFO, "undoing loser transaction's effect");
            IDatasetLifecycleManager datasetLifecycleManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getDatasetLifecycleManager();
            Iterator iter = jobLoserEntity2LSNsMap.entrySet().iterator();
            int undoCount = 0;
            while (iter.hasNext()) {
                Map.Entry loserEntity2LSNsMap = iter.next();
                undoLSNSet = (LinkedList<Long>)loserEntity2LSNsMap.getValue();
                Collections.reverse(undoLSNSet);
                Iterator iterator = undoLSNSet.iterator();
                while (iterator.hasNext()) {
                    long undoLSN = (Long)iterator.next();
                    logRecord = logReader.read(undoLSN);
                    if (logRecord == null) {
                        throw new ACIDException("IllegalState exception during abort( " + txnContext.getJobId() + ")");
                    }
                    RecoveryManager.undo(logRecord, datasetLifecycleManager);
                    ++undoCount;
                }
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("undone loser transaction's effect");
                LOGGER.info("[RecoveryManager's rollback log count] update/entityCommit/undo:" + updateLogCount + "/" + entityCommitLogCount + "/" + undoCount);
            }
        }
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) throws IOException {
        this.checkpointManager.doSharpCheckpoint();
    }

    public void dumpState(OutputStream os) throws IOException {
    }

    private static void undo(ILogRecord logRecord, IDatasetLifecycleManager datasetLifecycleManager) {
        block9: {
            try {
                ILSMIndex index = (ILSMIndex)datasetLifecycleManager.getIndex(logRecord.getDatasetId(), logRecord.getResourceId());
                ILSMIndexAccessor indexAccessor = index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                if (logRecord.getNewOp() == 1) {
                    indexAccessor.forceDelete(logRecord.getNewValue());
                    break block9;
                }
                if (logRecord.getNewOp() == 2) {
                    indexAccessor.forceInsert(logRecord.getOldValue());
                    break block9;
                }
                if (logRecord.getNewOp() == 3) {
                    if (logRecord.getOldValue() == null) {
                        try {
                            indexAccessor.forcePhysicalDelete(logRecord.getNewValue());
                            break block9;
                        }
                        catch (HyracksDataException hde) {
                            if (hde.getErrorCode() != 37) {
                                throw hde;
                            }
                            break block9;
                        }
                    }
                    indexAccessor.forceUpsert(logRecord.getOldValue());
                    break block9;
                }
                throw new IllegalStateException("Unsupported OperationType: " + logRecord.getNewOp());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to undo", e);
            }
        }
    }

    private static void redo(ILogRecord logRecord, IDatasetLifecycleManager datasetLifecycleManager) {
        block5: {
            try {
                int datasetId = logRecord.getDatasetId();
                long resourceId = logRecord.getResourceId();
                ILSMIndex index = (ILSMIndex)datasetLifecycleManager.getIndex(datasetId, resourceId);
                ILSMIndexAccessor indexAccessor = index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                if (logRecord.getNewOp() == 1) {
                    indexAccessor.forceInsert(logRecord.getNewValue());
                    break block5;
                }
                if (logRecord.getNewOp() == 2) {
                    indexAccessor.forceDelete(logRecord.getNewValue());
                    break block5;
                }
                if (logRecord.getNewOp() == 3) {
                    indexAccessor.forceUpsert(logRecord.getNewValue());
                    break block5;
                }
                throw new IllegalStateException("Unsupported OperationType: " + logRecord.getNewOp());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to redo", e);
            }
        }
    }

    private class JobEntityCommits {
        private static final String PARTITION_FILE_NAME_SEPARATOR = "_";
        private final int jobId;
        private final Set<TxnId> cachedEntityCommitTxns = new HashSet<TxnId>();
        private final List<File> jobEntitCommitOnDiskPartitionsFiles = new ArrayList<File>();
        private boolean preparedForSearch = false;
        private TxnId winnerEntity = null;
        private int currentPartitionSize = 0;
        private long partitionMaxLSN = 0L;
        private String currentPartitonName;

        public JobEntityCommits(int jobId) {
            this.jobId = jobId;
        }

        public void add(ILogRecord logRecord) throws IOException {
            if (this.preparedForSearch) {
                throw new IOException("Cannot add new entity commits after preparing for search.");
            }
            this.winnerEntity = new TxnId(logRecord.getJobId(), logRecord.getDatasetId(), logRecord.getPKHashValue(), logRecord.getPKValue(), logRecord.getPKValueSize(), true);
            this.cachedEntityCommitTxns.add(this.winnerEntity);
            this.partitionMaxLSN = logRecord.getLSN();
            this.currentPartitionSize += this.winnerEntity.getCurrentSize();
            if ((long)this.currentPartitionSize >= RecoveryManager.this.cachedEntityCommitsPerJobSize) {
                this.spillToDiskAndfreeMemory();
            }
        }

        public void spillToDiskAndfreeMemory() throws IOException {
            if (this.cachedEntityCommitTxns.size() > 0) {
                if (!this.preparedForSearch) {
                    this.writeCurrentPartitionToDisk();
                }
                this.cachedEntityCommitTxns.clear();
                this.partitionMaxLSN = 0L;
                this.currentPartitionSize = 0;
                this.currentPartitonName = "";
            }
        }

        public void prepareForSearch() throws IOException {
            if (this.jobEntitCommitOnDiskPartitionsFiles.size() > 0) {
                this.spillToDiskAndfreeMemory();
            } else {
                this.currentPartitonName = this.getPartitionName(this.partitionMaxLSN);
            }
            this.preparedForSearch = true;
        }

        public boolean containsEntityCommitForTxnId(long logLSN, TxnId txnId) throws IOException {
            if (this.jobEntitCommitOnDiskPartitionsFiles.size() == 0) {
                return this.cachedEntityCommitTxns.contains(txnId);
            }
            ArrayList<File> candidatePartitions = this.getCandidiatePartitions(logLSN);
            for (File partition : candidatePartitions) {
                if (!this.serachPartition(partition, txnId)) continue;
                return true;
            }
            return false;
        }

        public ArrayList<File> getCandidiatePartitions(long logLSN) {
            ArrayList<File> candidiatePartitions = new ArrayList<File>();
            for (File partition : this.jobEntitCommitOnDiskPartitionsFiles) {
                String partitionName = partition.getName();
                if (this.getPartitionMaxLSNFromName(partitionName) <= logLSN) continue;
                candidiatePartitions.add(partition);
            }
            return candidiatePartitions;
        }

        public void clear() {
            this.cachedEntityCommitTxns.clear();
            for (File partition : this.jobEntitCommitOnDiskPartitionsFiles) {
                partition.delete();
            }
            this.jobEntitCommitOnDiskPartitionsFiles.clear();
        }

        private boolean serachPartition(File partition, TxnId txnId) throws IOException {
            if (!partition.getName().equals(this.currentPartitonName)) {
                this.loadPartitionToMemory(partition, this.cachedEntityCommitTxns);
                this.currentPartitonName = partition.getName();
            }
            return this.cachedEntityCommitTxns.contains(txnId);
        }

        private String getPartitionName(long maxLSN) {
            return this.jobId + PARTITION_FILE_NAME_SEPARATOR + maxLSN;
        }

        private long getPartitionMaxLSNFromName(String partitionName) {
            return Long.valueOf(partitionName.substring(partitionName.indexOf(PARTITION_FILE_NAME_SEPARATOR) + 1));
        }

        private void writeCurrentPartitionToDisk() throws IOException {
            if (RecoveryManager.this.needToFreeMemory()) {
                RecoveryManager.this.freeJobsCachedEntities(this.jobId);
            }
            ByteBuffer buffer = ByteBuffer.allocate(this.currentPartitionSize);
            Iterator<TxnId> iterator = this.cachedEntityCommitTxns.iterator();
            while (iterator.hasNext()) {
                TxnId txnId = iterator.next();
                txnId.serialize(buffer);
                iterator.remove();
            }
            File partitionFile = RecoveryManager.this.createJobRecoveryFile(this.jobId, this.getPartitionName(this.partitionMaxLSN));
            try (FileOutputStream fileOutputstream = new FileOutputStream(partitionFile, false);
                 FileChannel fileChannel = fileOutputstream.getChannel();){
                buffer.flip();
                while (buffer.hasRemaining()) {
                    fileChannel.write(buffer);
                }
            }
            this.jobEntitCommitOnDiskPartitionsFiles.add(partitionFile);
        }

        private void loadPartitionToMemory(File partition, Set<TxnId> partitionTxn) throws IOException {
            partitionTxn.clear();
            if (RecoveryManager.this.needToFreeMemory()) {
                RecoveryManager.this.freeJobsCachedEntities(this.jobId);
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)partition.length());
            try (FileInputStream is = new FileInputStream(partition);){
                int readByte;
                while ((readByte = ((InputStream)is).read()) != -1) {
                    buffer.put((byte)readByte);
                }
            }
            buffer.flip();
            TxnId temp = null;
            while (buffer.remaining() != 0) {
                temp = TxnId.deserialize((ByteBuffer)buffer);
                partitionTxn.add(temp);
            }
        }
    }
}

