/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.messaging.NCMessageBroker;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class ExecuteStatementResponseMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final long requestMessageId;
    private String result;
    private IStatementExecutor.ResultMetadata metadata;
    private Throwable error;

    public ExecuteStatementResponseMessage(long requestMessageId) {
        this.requestMessageId = requestMessageId;
    }

    public void handle(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        NCMessageBroker mb = (NCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        MessageFuture future = mb.deregisterMessageFuture(this.requestMessageId);
        if (future != null) {
            future.complete((Object)this);
        }
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public IStatementExecutor.ResultMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IStatementExecutor.ResultMetadata metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return String.format("%s(id=%s): %d characters", this.getClass().getSimpleName(), this.requestMessageId, this.result != null ? this.result.length() : 0);
    }
}

