/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IRetryPolicyFactory;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.app.translator.DefaultStatementExecutorFactory;
import org.apache.asterix.app.translator.QueryTranslator;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.compiler.provider.AqlCompilationProvider;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.external.feed.watch.WaitForStateSubscriber;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.utils.FeedOperations;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobSpecification;

public class FeedEventsListener
extends ActiveEntityEventsListener {
    private final Feed feed;
    private final List<FeedConnection> feedConnections;

    public FeedEventsListener(IStatementExecutor statementExecutor, ICcApplicationContext appCtx, IHyracksClientConnection hcc, EntityId entityId, List<Dataset> datasets, AlgebricksAbsolutePartitionConstraint locations, String runtimeName, IRetryPolicyFactory retryPolicyFactory, Feed feed, List<FeedConnection> feedConnections) throws HyracksDataException {
        super(statementExecutor, appCtx, hcc, entityId, datasets, locations, runtimeName, retryPolicyFactory);
        this.feed = feed;
        this.feedConnections = feedConnections;
    }

    @Override
    public synchronized void remove(Dataset dataset) throws HyracksDataException {
        super.remove(dataset);
        this.feedConnections.removeIf(o -> o.getDataverseName().equals(dataset.getDataverseName()) && o.getDatasetName().equals(dataset.getDatasetName()));
    }

    public synchronized void addFeedConnection(FeedConnection feedConnection) {
        this.feedConnections.add(feedConnection);
    }

    public Feed getFeed() {
        return this.feed;
    }

    @Override
    protected void doStart(MetadataProvider mdProvider) throws HyracksDataException, AlgebricksException {
        try {
            AqlCompilationProvider compilationProvider = new AqlCompilationProvider();
            StorageComponentProvider storageComponentProvider = new StorageComponentProvider();
            DefaultStatementExecutorFactory statementExecutorFactory = new DefaultStatementExecutorFactory();
            Pair<JobSpecification, AlgebricksAbsolutePartitionConstraint> jobInfo = FeedOperations.buildStartFeedJob(((QueryTranslator)this.statementExecutor).getSessionOutput(), mdProvider, this.feed, this.feedConnections, (ILangCompilationProvider)compilationProvider, storageComponentProvider, statementExecutorFactory, this.hcc);
            JobSpecification feedJob = (JobSpecification)jobInfo.getLeft();
            WaitForStateSubscriber eventSubscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, Collections.singleton(ActivityState.RUNNING));
            feedJob.setProperty("ActiveJob", (Serializable)this.entityId);
            this.setLocations((AlgebricksAbsolutePartitionConstraint)jobInfo.getRight());
            boolean wait = Boolean.parseBoolean((String)mdProvider.getConfig().get("wait-for-completion-feed"));
            JobUtils.runJob((IHyracksClientConnection)this.hcc, (JobSpecification)feedJob, (boolean)false);
            eventSubscriber.sync();
            if (wait) {
                WaitForStateSubscriber stoppedSubscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, EnumSet.of(ActivityState.STOPPED, ActivityState.PERMANENTLY_FAILED));
                stoppedSubscriber.sync();
            }
        }
        catch (AlgebricksException e) {
            throw e;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    protected Void doStop(MetadataProvider metadataProvider) throws HyracksDataException, AlgebricksException {
        WaitForStateSubscriber eventSubscriber = new WaitForStateSubscriber((IActiveEntityEventsListener)this, Collections.singleton(ActivityState.STOPPED));
        try {
            for (int i = 0; i < this.getLocations().getLocations().length; ++i) {
                String intakeLocation = this.getLocations().getLocations()[i];
                FeedOperations.SendStopMessageToNode(metadataProvider.getApplicationContext(), this.entityId, intakeLocation, i);
            }
            eventSubscriber.sync();
        }
        catch (AlgebricksException e) {
            throw e;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return null;
    }

    @Override
    protected void setRunning(MetadataProvider metadataProvider, boolean running) throws HyracksDataException, AlgebricksException {
    }

    @Override
    protected Void doSuspend(MetadataProvider metadataProvider) throws HyracksDataException, AlgebricksException {
        throw new RuntimeDataException(27, new Serializable[0]);
    }

    @Override
    protected void doResume(MetadataProvider metadataProvider) throws HyracksDataException, AlgebricksException {
        throw new RuntimeDataException(27, new Serializable[0]);
    }
}

