/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultPrinter;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.lang.aql.parser.TokenMgrError;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionOutput;
import org.apache.http.ParseException;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.util.JSONUtil;
import org.apache.log4j.Logger;

public class ResultUtil {
    private static final Logger LOGGER = Logger.getLogger((String)ResultUtil.class.getName());
    public static final Map<Character, String> HTML_ENTITIES = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleImmutableEntry<Character, String>(Character.valueOf('\"'), "&quot;"), new AbstractMap.SimpleImmutableEntry<Character, String>(Character.valueOf('&'), "&amp;"), new AbstractMap.SimpleImmutableEntry<Character, String>(Character.valueOf('<'), "&lt;"), new AbstractMap.SimpleImmutableEntry<Character, String>(Character.valueOf('>'), "&gt;")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));

    private ResultUtil() {
    }

    public static String escapeHTML(String aString) {
        String escaped = aString;
        for (Map.Entry<Character, String> entry : HTML_ENTITIES.entrySet()) {
            if (escaped.indexOf(entry.getKey().charValue()) < 0) continue;
            escaped = escaped.replace(entry.getKey().toString(), entry.getValue());
        }
        return escaped;
    }

    public static void printResults(IApplicationContext appCtx, ResultReader resultReader, SessionOutput output, IStatementExecutor.Stats stats, ARecordType recordType) throws HyracksDataException {
        new ResultPrinter(appCtx, output, stats, recordType).print(resultReader);
    }

    public static void printResults(IApplicationContext appCtx, String record, SessionOutput output, IStatementExecutor.Stats stats, ARecordType recordType) throws HyracksDataException {
        new ResultPrinter(appCtx, output, stats, recordType).print(record);
    }

    public static void printResultHandle(SessionOutput output, ResultHandle handle) throws HyracksDataException {
        try {
            AlgebricksAppendable app = new AlgebricksAppendable((Appendable)output.out());
            output.appendHandle(app, handle.toString());
        }
        catch (AlgebricksException e) {
            LOGGER.warn((Object)"error printing handle", (Throwable)e);
        }
    }

    public static void printStatus(SessionOutput output, AbstractQueryApiServlet.ResultStatus rs) {
        try {
            AlgebricksAppendable app = new AlgebricksAppendable((Appendable)output.out());
            output.appendStatus(app, rs.str());
        }
        catch (AlgebricksException e) {
            LOGGER.warn((Object)"error printing status", (Throwable)e);
        }
    }

    public static void printStatus(PrintWriter pw, AbstractQueryApiServlet.ResultStatus rs, boolean comma) {
        ResultUtil.printField(pw, AbstractQueryApiServlet.ResultFields.STATUS.str(), rs.str(), comma);
    }

    public static void printError(PrintWriter pw, Throwable e) {
        ResultUtil.printError(pw, e, true);
    }

    public static void printError(PrintWriter pw, Throwable e, boolean comma) {
        ResultUtil.printError(pw, e, 1, comma);
    }

    public static void printError(PrintWriter pw, Throwable e, int code, boolean comma) {
        Throwable rootCause = ResultUtil.getRootCause(e);
        String msg = rootCause.getMessage();
        if (!(rootCause instanceof AlgebricksException || rootCause instanceof HyracksException || rootCause instanceof TokenMgrError || rootCause instanceof org.apache.asterix.aqlplus.parser.TokenMgrError)) {
            msg = rootCause.getClass().getSimpleName() + (msg == null ? "" : ": " + msg);
        }
        ResultUtil.printError(pw, msg, code, comma);
    }

    public static void printError(PrintWriter pw, String msg, int code, boolean comma) {
        pw.print("\t\"");
        pw.print(AbstractQueryApiServlet.ResultFields.ERRORS.str());
        pw.print("\": [{ \n");
        ResultUtil.printField(pw, AbstractQueryApiServlet.ErrorField.CODE.str(), code);
        ResultUtil.printField(pw, AbstractQueryApiServlet.ErrorField.MSG.str(), JSONUtil.escape((String)msg), false);
        pw.print(comma ? "\t}],\n" : "\t}]\n");
    }

    public static void printField(PrintWriter pw, String name, String value) {
        ResultUtil.printField(pw, name, value, true);
    }

    public static void printField(PrintWriter pw, String name, long value) {
        ResultUtil.printField(pw, name, value, true);
    }

    public static void printField(PrintWriter pw, String name, String value, boolean comma) {
        ResultUtil.printFieldInternal(pw, name, "\"" + value + "\"", comma);
    }

    public static void printField(PrintWriter pw, String name, long value, boolean comma) {
        ResultUtil.printFieldInternal(pw, name, String.valueOf(value), comma);
    }

    protected static void printFieldInternal(PrintWriter pw, String name, String value, boolean comma) {
        pw.print("\t\"");
        pw.print(name);
        pw.print("\": ");
        pw.print(value);
        if (comma) {
            pw.print(',');
        }
        pw.print('\n');
    }

    public static ObjectNode getErrorResponse(int errorCode, String errorMessage, String errorSummary, String errorStackTrace) {
        ObjectMapper om = new ObjectMapper();
        ObjectNode errorResp = om.createObjectNode();
        ArrayNode errorArray = om.createArrayNode();
        errorArray.add(errorCode);
        errorArray.add(errorMessage);
        errorResp.set("error-code", (JsonNode)errorArray);
        if (!"".equals(errorSummary)) {
            errorResp.put("summary", errorSummary);
        } else {
            errorResp.put("summary", errorMessage);
        }
        errorResp.put("stacktrace", errorStackTrace);
        return errorResp;
    }

    public static void webUIErrorHandler(PrintWriter out, Exception e) {
        String errorTemplate = ResultUtil.readTemplateFile("/webui/errortemplate.html", "%s\n%s\n%s");
        String errorOutput = String.format(errorTemplate, ResultUtil.extractErrorMessage(e), ResultUtil.extractErrorSummary(e), ResultUtil.extractFullStackTrace(e));
        out.println(errorOutput);
    }

    public static void webUIParseExceptionHandler(PrintWriter out, Throwable e, String query) {
        String errorTemplate = ResultUtil.readTemplateFile("/webui/errortemplate_message.html", "<pre class=\"error\">%s\n</pre>");
        String errorOutput = String.format(errorTemplate, ResultUtil.buildParseExceptionMessage(e, query));
        out.println(errorOutput);
    }

    public static void apiErrorHandler(PrintWriter out, Exception e) {
        int errorCode = 99;
        if (e instanceof ParseException) {
            errorCode = 2;
        } else if (e instanceof AlgebricksException) {
            errorCode = 3;
        } else if (e instanceof HyracksDataException) {
            errorCode = 4;
        }
        ObjectNode errorResp = ResultUtil.getErrorResponse(errorCode, ResultUtil.extractErrorMessage(e), ResultUtil.extractErrorSummary(e), ResultUtil.extractFullStackTrace(e));
        out.write(errorResp.toString());
    }

    public static String buildParseExceptionMessage(Throwable e, String query) {
        Pattern p;
        Matcher m;
        StringBuilder errorMessage = new StringBuilder();
        String message = e.getMessage();
        message = message.replace("<", "&lt");
        message = message.replace(">", "&gt");
        errorMessage.append("Error: " + message + "\n");
        int pos = message.indexOf("line");
        if (pos > 0 && (m = (p = Pattern.compile("\\d+")).matcher(message)).find(pos)) {
            String[] lines;
            int lineNo = Integer.parseInt(message.substring(m.start(), m.end()));
            if (lineNo > (lines = query.split("\n")).length) {
                errorMessage.append("===> &ltBLANK LINE&gt \n");
            } else {
                String line = lines[lineNo - 1];
                errorMessage.append("==> " + line);
            }
        }
        return errorMessage.toString();
    }

    public static Throwable getRootCause(Throwable cause) {
        Throwable currentCause = cause;
        for (Throwable nextCause = cause.getCause(); nextCause != null && nextCause != currentCause; nextCause = nextCause.getCause()) {
            currentCause = nextCause;
        }
        return currentCause;
    }

    private static String extractErrorMessage(Throwable e) {
        Throwable cause = ResultUtil.getRootCause(e);
        String fullyQualifiedExceptionClassName = cause.getClass().getName();
        String[] hierarchySplits = fullyQualifiedExceptionClassName.split("\\.");
        String exceptionClassName = hierarchySplits[hierarchySplits.length - 1];
        String localizedMessage = cause.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = "Internal error. Please check instance logs for further details.";
        }
        return localizedMessage + " [" + exceptionClassName + "]";
    }

    private static String extractErrorSummary(Throwable e) {
        Throwable cause;
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append(cause.getLocalizedMessage());
        for (cause = e; cause != null; cause = cause.getCause()) {
            StackTraceElement[] stackTraceElements = cause.getStackTrace();
            errorMessageBuilder.append(stackTraceElements.length > 0 ? "\n caused by: " + stackTraceElements[0] : "");
        }
        return errorMessageBuilder.toString();
    }

    public static String extractFullStackTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static String readTemplateFile(String path, String defaultTemplate) {
        String errorTemplate = defaultTemplate;
        try {
            String resourcePath = "/webui/errortemplate_message.html";
            InputStream is = ResultUtil.class.getResourceAsStream(resourcePath);
            InputStreamReader isr = new InputStreamReader(is);
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
            errorTemplate = sb.toString();
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)"Unable to read template error message file", (Throwable)ioe);
        }
        return errorTemplate;
    }

    public static SessionOutput.ResultDecorator createPreResultDecorator() {
        return new SessionOutput.ResultDecorator(){
            int resultNo = -1;

            public AlgebricksAppendable append(AlgebricksAppendable app) throws AlgebricksException {
                app.append((CharSequence)"\t\"");
                app.append((CharSequence)AbstractQueryApiServlet.ResultFields.RESULTS.str());
                if (this.resultNo >= 0) {
                    app.append('-').append((CharSequence)String.valueOf(this.resultNo));
                }
                ++this.resultNo;
                app.append((CharSequence)"\": ");
                return app;
            }
        };
    }

    public static SessionOutput.ResultDecorator createPostResultDecorator() {
        return app -> app.append((CharSequence)"\t,\n");
    }

    public static SessionOutput.ResultAppender createResultHandleAppender(String handleUrl) {
        return (app, handle) -> app.append((CharSequence)"\t\"").append((CharSequence)AbstractQueryApiServlet.ResultFields.HANDLE.str()).append((CharSequence)"\": \"").append((CharSequence)handleUrl).append((CharSequence)handle).append((CharSequence)"\",\n");
    }

    public static SessionOutput.ResultAppender createResultStatusAppender() {
        return (app, status) -> app.append((CharSequence)"\t\"").append((CharSequence)AbstractQueryApiServlet.ResultFields.STATUS.str()).append((CharSequence)"\": \"").append((CharSequence)status).append((CharSequence)"\",\n");
    }
}

