/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.api.http.server.AbstractQueryApiServlet;
import org.apache.asterix.api.http.server.RestApiServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.ResultHandle;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.dataset.DatasetJobRecord;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class QueryResultApiServlet
extends AbstractQueryApiServlet {
    private static final Logger LOGGER = Logger.getLogger(QueryResultApiServlet.class.getName());

    public QueryResultApiServlet(ConcurrentMap<String, Object> ctx, IApplicationContext appCtx, String ... paths) {
        super(appCtx, ctx, paths);
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        HttpUtil.setContentType((IServletResponse)response, (String)"text/html", (String)"utf-8");
        PrintWriter out = response.writer();
        String strHandle = this.localPath(request);
        ResultHandle handle = ResultHandle.parse(strHandle);
        if (handle == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        IHyracksDataset hds = this.getHyracksDataset();
        ResultReader resultReader = new ResultReader(hds, handle.getJobId(), handle.getResultSetId());
        try {
            HttpResponseStatus httpStatus;
            DatasetJobRecord.Status status = resultReader.getStatus();
            if (status == null) {
                httpStatus = HttpResponseStatus.NOT_FOUND;
            } else {
                switch (status.getState()) {
                    case SUCCESS: {
                        httpStatus = HttpResponseStatus.OK;
                        break;
                    }
                    case RUNNING: 
                    case IDLE: 
                    case FAILED: {
                        httpStatus = HttpResponseStatus.NOT_FOUND;
                        break;
                    }
                    default: {
                        httpStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                    }
                }
            }
            response.setStatus(httpStatus);
            if (httpStatus != HttpResponseStatus.OK) {
                return;
            }
            SessionOutput sessionOutput = RestApiServlet.initResponse(request, response);
            ResultUtil.printResults(this.appCtx, resultReader, sessionOutput, new IStatementExecutor.Stats(), null);
        }
        catch (HyracksDataException e) {
            int errorCode = e.getErrorCode();
            if (24 == errorCode) {
                LOGGER.log(Level.INFO, "No results for: \"" + strHandle + "\"");
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                return;
            }
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            out.println(e.getMessage());
            LOGGER.log(Level.WARNING, "Error retrieving result for \"" + strHandle + "\"", e);
        }
        catch (Exception e) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            LOGGER.log(Level.WARNING, "Error retrieving result for \"" + strHandle + "\"", e);
        }
        if (out.checkError()) {
            LOGGER.warning("Error flushing output writer for \"" + strHandle + "\"");
        }
    }
}

