/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.message.ExecuteStatementRequestMessage;
import org.apache.asterix.app.message.ExecuteStatementResponseMessage;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.SessionOutput;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.ipc.exceptions.IPCException;

public class NCQueryServiceServlet
extends QueryServiceServlet {
    public NCQueryServiceServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, ILangExtension.Language queryLanguage) {
        super(ctx, paths, appCtx, queryLanguage, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeStatement(String statementsText, SessionOutput sessionOutput, IStatementExecutor.ResultDelivery delivery, IStatementExecutor.Stats stats, QueryServiceServlet.RequestParameters param, String handleUrl, long[] outExecStartEnd) throws Exception {
        ExecuteStatementResponseMessage responseMsg;
        INCServiceContext ncCtx = (INCServiceContext)this.serviceCtx;
        INCMessageBroker ncMb = (INCMessageBroker)ncCtx.getMessageBroker();
        IStatementExecutor.ResultDelivery ccDelivery = delivery == IStatementExecutor.ResultDelivery.IMMEDIATE ? IStatementExecutor.ResultDelivery.DEFERRED : delivery;
        MessageFuture responseFuture = ncMb.registerMessageFuture();
        try {
            ExecuteStatementRequestMessage requestMsg = new ExecuteStatementRequestMessage(ncCtx.getNodeId(), responseFuture.getFutureId(), this.queryLanguage, statementsText, sessionOutput.config(), ccDelivery, param.clientContextID, handleUrl);
            outExecStartEnd[0] = System.nanoTime();
            ncMb.sendMessageToCC((ICcAddressedMessage)requestMsg);
            responseMsg = (ExecuteStatementResponseMessage)responseFuture.get(ExecuteStatementResponseMessage.DEFAULT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            outExecStartEnd[1] = System.nanoTime();
        }
        finally {
            ncMb.deregisterMessageFuture(responseFuture.getFutureId());
        }
        Throwable err = responseMsg.getError();
        if (err != null) {
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof Exception) {
                throw (Exception)err;
            }
            throw new Exception(err.toString(), err);
        }
        IStatementExecutor.ResultMetadata resultMetadata = responseMsg.getMetadata();
        if (delivery == IStatementExecutor.ResultDelivery.IMMEDIATE && !resultMetadata.getResultSets().isEmpty()) {
            for (Triple rsmd : resultMetadata.getResultSets()) {
                ResultReader resultReader = new ResultReader(this.getHyracksDataset(), (JobId)rsmd.getLeft(), (ResultSetId)rsmd.getMiddle());
                ResultUtil.printResults(this.appCtx, resultReader, sessionOutput, stats, (ARecordType)rsmd.getRight());
            }
        } else {
            sessionOutput.out().append(responseMsg.getResult());
        }
    }

    @Override
    protected HttpResponseStatus handleExecuteStatementException(Throwable t) {
        if (t instanceof IPCException || t instanceof TimeoutException) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.WARNING, t.toString(), t);
            return HttpResponseStatus.SERVICE_UNAVAILABLE;
        }
        return super.handleExecuteStatementException(t);
    }
}

