/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.api.http.server.FilePartition;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.utils.FlushDatasetUtil;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class ConnectorApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(ConnectorApiServlet.class.getName());
    private ICcApplicationContext appCtx;

    public ConnectorApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void get(IServletRequest request, IServletResponse response) {
        response.setStatus(HttpResponseStatus.OK);
        try {
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failure setting content type", e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            response.writer().write(e.toString());
            return;
        }
        PrintWriter out = response.writer();
        try {
            ObjectMapper om = new ObjectMapper();
            ObjectNode jsonResponse = om.createObjectNode();
            String dataverseName = request.getParameter((CharSequence)"dataverseName");
            String datasetName = request.getParameter((CharSequence)"datasetName");
            if (dataverseName == null || datasetName == null) {
                jsonResponse.put("error", "Parameter dataverseName or datasetName is null,");
                out.write(jsonResponse.toString());
                return;
            }
            IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
            MetadataManager.INSTANCE.init();
            MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            MetadataProvider metadataProvider = new MetadataProvider(this.appCtx, null);
            try {
                metadataProvider.setMetadataTxnContext(mdTxnCtx);
                Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
                if (dataset == null) {
                    jsonResponse.put("error", "Dataset " + datasetName + " does not exist in dataverse " + dataverseName);
                    out.write(jsonResponse.toString());
                    out.flush();
                    return;
                }
                boolean temp = dataset.getDatasetDetails().isTemp();
                FileSplit[] fileSplits = metadataProvider.splitsForIndex(mdTxnCtx, dataset, datasetName);
                ARecordType recordType = (ARecordType)metadataProvider.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
                List primaryKeys = dataset.getPrimaryKeys();
                StringBuilder pkStrBuf = new StringBuilder();
                for (List keys : primaryKeys) {
                    for (String key : keys) {
                        pkStrBuf.append(key).append(",");
                    }
                }
                pkStrBuf.delete(pkStrBuf.length() - 1, pkStrBuf.length());
                this.formResponseObject(jsonResponse, fileSplits, recordType, pkStrBuf.toString(), temp, hcc.getNodeControllerInfos());
                FlushDatasetUtil.flushDataset(hcc, metadataProvider, dataverseName, datasetName);
                MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                out.write(jsonResponse.toString());
            }
            finally {
                metadataProvider.getLocks().unlock();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure handling a request", e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            out.write(e.toString());
        }
        finally {
            out.flush();
        }
    }

    private void formResponseObject(ObjectNode jsonResponse, FileSplit[] fileSplits, ARecordType recordType, String primaryKeys, boolean temp, Map<String, NodeControllerInfo> nodeMap) {
        ObjectMapper om = new ObjectMapper();
        ArrayNode partititons = om.createArrayNode();
        jsonResponse.put("temp", temp);
        jsonResponse.put("keys", primaryKeys);
        jsonResponse.set("type", (JsonNode)recordType.toJSON());
        for (FileSplit split : fileSplits) {
            String ipAddress = nodeMap.get(split.getNodeName()).getNetworkAddress().getAddress();
            String path = split.getPath();
            FilePartition partition = new FilePartition(ipAddress, path);
            partititons.add((JsonNode)partition.toObjectNode());
        }
        jsonResponse.set("splits", (JsonNode)partititons);
    }
}

