/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.api.http.server.ClusterApiServlet;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class ClusterControllerDetailsApiServlet
extends ClusterApiServlet {
    private static final Logger LOGGER = Logger.getLogger(ClusterControllerDetailsApiServlet.class.getName());
    private final ObjectMapper om = new ObjectMapper();

    public ClusterControllerDetailsApiServlet(ConcurrentMap<String, Object> ctx, String ... paths) {
        super(ctx, paths);
    }

    @Override
    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        PrintWriter responseWriter = response.writer();
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        try {
            response.setStatus(HttpResponseStatus.OK);
            ObjectNode json = "".equals(this.localPath(request)) ? (ObjectNode)this.getClusterStateJSON(request, "../").get("cc") : this.processNode(request, hcc);
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
            responseWriter.write(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json));
        }
        catch (IllegalArgumentException e) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }

    private ObjectNode processNode(IServletRequest request, IHyracksClientConnection hcc) throws Exception {
        String localPath = this.localPath(request);
        if (localPath.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        String[] parts = localPath.substring(1).split("/");
        if ("".equals(localPath)) {
            return (ObjectNode)this.getClusterStateJSON(request, "../../").get("cc");
        }
        if (parts.length == 1) {
            switch (parts[0]) {
                case "config": {
                    return (ObjectNode)this.om.readValue(hcc.getNodeDetailsJSON(null, false, true), ObjectNode.class);
                }
                case "stats": {
                    return (ObjectNode)this.om.readValue(hcc.getNodeDetailsJSON(null, true, false), ObjectNode.class);
                }
                case "threaddump": {
                    return this.processCCThreadDump(hcc);
                }
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private ObjectNode processCCThreadDump(IHyracksClientConnection hcc) throws Exception {
        String dump = hcc.getThreadDump(null);
        if (dump == null) {
            throw new IllegalArgumentException();
        }
        return (ObjectNode)this.om.readTree(dump);
    }
}

