/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.aql.parser.TokenMgrError;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataset.IHyracksDataset;
import org.apache.hyracks.client.dataset.HyracksDataset;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.StaticResourceServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class ApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(ApiServlet.class.getName());
    public static final String HTML_STATEMENT_SEPARATOR = "<!-- BEGIN -->";
    private final ICcApplicationContext appCtx;
    private final ILangCompilationProvider aqlCompilationProvider;
    private final ILangCompilationProvider sqlppCompilationProvider;
    private final IStatementExecutorFactory statementExectorFactory;
    private final IStorageComponentProvider componentProvider;

    public ApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx, ILangCompilationProvider aqlCompilationProvider, ILangCompilationProvider sqlppCompilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider) {
        super(ctx, paths);
        this.appCtx = appCtx;
        this.aqlCompilationProvider = aqlCompilationProvider;
        this.sqlppCompilationProvider = sqlppCompilationProvider;
        this.statementExectorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void post(IServletRequest request, IServletResponse response) {
        SessionConfig.OutputFormat format;
        ILangCompilationProvider compilationProvider = "AQL".equals(request.getParameter((CharSequence)"query-language")) ? this.aqlCompilationProvider : this.sqlppCompilationProvider;
        IParserFactory parserFactory = compilationProvider.getParserFactory();
        PrintWriter out = response.writer();
        boolean csvAndHeader = false;
        String output = request.getParameter((CharSequence)"output-format");
        try {
            format = SessionConfig.OutputFormat.valueOf((String)output);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.INFO, output + ": unsupported output-format, using " + SessionConfig.OutputFormat.CLEAN_JSON + " instead", e);
            format = SessionConfig.OutputFormat.CLEAN_JSON;
        }
        String query = request.getParameter((CharSequence)"query");
        String wrapperArray = request.getParameter((CharSequence)"wrapper-array");
        String printExprParam = request.getParameter((CharSequence)"print-expr-tree");
        String printRewrittenExprParam = request.getParameter((CharSequence)"print-rewritten-expr-tree");
        String printLogicalPlanParam = request.getParameter((CharSequence)"print-logical-plan");
        String printOptimizedLogicalPlanParam = request.getParameter((CharSequence)"print-optimized-logical-plan");
        String printJob = request.getParameter((CharSequence)"print-job");
        String executeQuery = request.getParameter((CharSequence)"execute-query");
        try {
            response.setStatus(HttpResponseStatus.OK);
            HttpUtil.setContentType((IServletResponse)response, (String)"text/html", (String)"utf-8");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failure setting content type", e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        try {
            IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
            IHyracksDataset hds = (IHyracksDataset)this.ctx.get("org.apache.asterix.HYRACKS_DATASET");
            if (hds == null) {
                ConcurrentMap concurrentMap = this.ctx;
                synchronized (concurrentMap) {
                    hds = (IHyracksDataset)this.ctx.get("org.apache.asterix.HYRACKS_DATASET");
                    if (hds == null) {
                        hds = new HyracksDataset(hcc, this.appCtx.getCompilerProperties().getFrameSize(), 1);
                        this.ctx.put("org.apache.asterix.HYRACKS_DATASET", hds);
                    }
                }
            }
            IParser parser = parserFactory.createParser(query);
            List aqlStatements = parser.parse();
            SessionConfig sessionConfig = new SessionConfig(format, true, ApiServlet.isSet(executeQuery), true);
            sessionConfig.set("format-html", true);
            sessionConfig.set("format-csv-header", csvAndHeader);
            sessionConfig.set("format-wrapper-array", ApiServlet.isSet(wrapperArray));
            sessionConfig.setOOBData(ApiServlet.isSet(printExprParam), ApiServlet.isSet(printRewrittenExprParam), ApiServlet.isSet(printLogicalPlanParam), ApiServlet.isSet(printOptimizedLogicalPlanParam), ApiServlet.isSet(printJob));
            SessionOutput sessionOutput = new SessionOutput(sessionConfig, out);
            MetadataManager.INSTANCE.init();
            IStatementExecutor translator = this.statementExectorFactory.create(this.appCtx, aqlStatements, sessionOutput, compilationProvider, this.componentProvider);
            long startTime = System.currentTimeMillis();
            translator.compileAndExecute(hcc, hds, IStatementExecutor.ResultDelivery.IMMEDIATE, null, new IStatementExecutor.Stats());
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println(HTML_STATEMENT_SEPARATOR);
            out.println("<PRE>Duration of all jobs: " + duration + " sec</PRE>");
        }
        catch (org.apache.asterix.aqlplus.parser.TokenMgrError | AsterixException | TokenMgrError pe) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.INFO, pe.toString(), pe);
            ResultUtil.webUIParseExceptionHandler(out, pe, query);
        }
        catch (Exception e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.SEVERE, e.getMessage(), e);
            ResultUtil.webUIErrorHandler(out, e);
        }
    }

    protected void get(IServletRequest request, IServletResponse response) {
        String resourcePath = null;
        String requestURI = request.getHttpRequest().uri();
        response.setStatus(HttpResponseStatus.OK);
        if ("/".equals(requestURI)) {
            try {
                HttpUtil.setContentType((IServletResponse)response, (String)"text/html", (String)"utf-8");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failure setting content type", e);
                response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            resourcePath = "/webui/querytemplate.html";
        } else {
            resourcePath = requestURI;
        }
        try (InputStream is = ApiServlet.class.getResourceAsStream(resourcePath);){
            if (is == null) {
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                return;
            }
            if (resourcePath.endsWith(".png")) {
                BufferedImage img = ImageIO.read(is);
                HttpUtil.setContentType((IServletResponse)response, (String)"image/png");
                OutputStream outputStream = response.outputStream();
                String formatName = "png";
                ImageIO.write((RenderedImage)img, formatName, outputStream);
                outputStream.close();
                return;
            }
            String type = HttpUtil.mime((String)StaticResourceServlet.extension((String)resourcePath));
            HttpUtil.setContentType((IServletResponse)response, (String)("".equals(type) ? "text/plain" : type), (String)"utf-8");
            this.writeOutput(response, is, resourcePath);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failure handling request", e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return;
        }
    }

    private void writeOutput(IServletResponse response, InputStream is, String resourcePath) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            StringBuilder sb = new StringBuilder();
            try {
                line = br.readLine();
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.WARNING, "NPE reading resource " + resourcePath + ", assuming JDK-8080094; returning 404", e);
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                if (br != null) {
                    if (var7_9 != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        br.close();
                    }
                }
                if (isr != null) {
                    if (var5_5 != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        isr.close();
                    }
                }
                return;
            }
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
            PrintWriter out = response.writer();
            out.println(sb.toString());
        }
    }

    private static boolean isSet(String requestParameter) {
        return requestParameter != null && "true".equals(requestParameter);
    }
}

