/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.common;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.hyracks.bootstrap.CCApplication;
import org.apache.asterix.hyracks.bootstrap.NCApplication;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.application.ICCApplication;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.client.HyracksConnection;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.util.file.FileUtil;
import org.kohsuke.args4j.CmdLineException;

public class AsterixHyracksIntegrationUtil {
    public static final int DEFAULT_HYRACKS_CC_CLIENT_PORT = 1098;
    public static final int DEFAULT_HYRACKS_CC_CLUSTER_PORT = 1099;
    public ClusterControllerService cc;
    public NodeControllerService[] ncs = new NodeControllerService[0];
    public IHyracksClientConnection hcc;
    private static final String DEFAULT_STORAGE_PATH;
    private static String storagePath;
    private ConfigManager configManager;
    private List<String> nodeNames;

    public void init(boolean deleteOldInstanceData) throws Exception {
        ICCApplication ccApplication = this.createCCApplication();
        this.configManager = new ConfigManager();
        ccApplication.registerConfig((IConfigManager)this.configManager);
        CCConfig ccConfig = this.createCCConfig(this.configManager);
        this.cc = new ClusterControllerService(ccConfig, ccApplication);
        this.nodeNames = ccConfig.getConfigManager().getNodeNames();
        if (deleteOldInstanceData) {
            this.deleteTransactionLogs();
            this.removeTestStorageFiles();
        }
        ArrayList<NodeControllerService> nodeControllers = new ArrayList<NodeControllerService>();
        for (String nodeId : this.nodeNames) {
            this.configManager.set(nodeId, (IOption)NCConfig.Option.NCSERVICE_PORT, (Object)-1);
            INCApplication iNCApplication = this.createNCApplication();
            ConfigManager ncConfigManager = new ConfigManager();
            iNCApplication.registerConfig((IConfigManager)ncConfigManager);
            nodeControllers.add(new NodeControllerService(this.fixupIODevices(this.createNCConfig(nodeId, ncConfigManager)), iNCApplication));
        }
        this.cc.start();
        this.nodeNames = ccConfig.getConfigManager().getNodeNames();
        ArrayList<1> startupThreads = new ArrayList<1>();
        for (final NodeControllerService nodeControllerService : nodeControllers) {
            Thread ncStartThread = new Thread("IntegrationUtil-" + nodeControllerService.getId()){

                @Override
                public void run() {
                    try {
                        nodeControllerService.start();
                    }
                    catch (Exception e) {
                        LoggerHolder.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            ncStartThread.start();
            startupThreads.add(ncStartThread);
        }
        for (Thread thread : startupThreads) {
            thread.join();
        }
        ClusterStateManager.INSTANCE.waitForState(IClusterManagementWork.ClusterState.ACTIVE);
        this.hcc = new HyracksConnection(this.cc.getConfig().getClientListenAddress(), this.cc.getConfig().getClientListenPort());
        this.ncs = nodeControllers.toArray(new NodeControllerService[nodeControllers.size()]);
    }

    protected CCConfig createCCConfig(ConfigManager configManager) throws IOException {
        CCConfig ccConfig = new CCConfig(configManager);
        ccConfig.setClusterListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ccConfig.setClientListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ccConfig.setClientListenPort(1098);
        ccConfig.setClusterListenPort(1099);
        ccConfig.setResultTTL(120000L);
        ccConfig.setResultSweepThreshold(1000L);
        ccConfig.setEnforceFrameWriterProtocol(true);
        configManager.set((IOption)ControllerConfig.Option.DEFAULT_DIR, (Object)FileUtil.joinPath((String[])new String[]{this.getDefaultStoragePath(), "asterixdb"}));
        return ccConfig;
    }

    protected ICCApplication createCCApplication() {
        return new CCApplication();
    }

    protected NCConfig createNCConfig(String ncName, ConfigManager configManager) {
        NCConfig ncConfig = new NCConfig(ncName, configManager);
        ncConfig.setClusterAddress("localhost");
        ncConfig.setClusterPort(1099);
        ncConfig.setClusterListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setDataListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setResultListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setMessagingListenAddress(Inet4Address.getLoopbackAddress().getHostAddress());
        ncConfig.setResultTTL(120000L);
        ncConfig.setResultSweepThreshold(1000L);
        ncConfig.setVirtualNC();
        configManager.set((IOption)ControllerConfig.Option.DEFAULT_DIR, (Object)FileUtil.joinPath((String[])new String[]{this.getDefaultStoragePath(), "asterixdb", ncName}));
        return ncConfig;
    }

    protected INCApplication createNCApplication() {
        return new NCApplication();
    }

    private NCConfig fixupIODevices(NCConfig ncConfig) throws IOException, AsterixException, CmdLineException {
        ncConfig.getConfigManager().processConfig();
        String[] nodeStores = ncConfig.getAppConfig().getStringArray((IOption)NCConfig.Option.IODEVICES);
        if (nodeStores == null) {
            throw new IllegalStateException("Couldn't find stores for NC: " + ncConfig.getNodeId());
        }
        LoggerHolder.LOGGER.info("Using the path: " + this.getDefaultStoragePath());
        for (int i = 0; i < nodeStores.length; ++i) {
            nodeStores[i] = FileUtil.joinPath((String[])new String[]{this.getDefaultStoragePath(), ncConfig.getNodeId(), nodeStores[i]});
        }
        ncConfig.getConfigManager().set(ncConfig.getNodeId(), (IOption)NCConfig.Option.IODEVICES, (Object)nodeStores);
        return ncConfig;
    }

    public IHyracksClientConnection getHyracksClientConnection() {
        return this.hcc;
    }

    public void deinit(boolean deleteOldInstanceData) throws Exception {
        ArrayList<2> stopNCThreads = new ArrayList<2>();
        for (final NodeControllerService nodeControllerService : this.ncs) {
            if (nodeControllerService == null) continue;
            Thread ncStopThread = new Thread(){

                @Override
                public void run() {
                    try {
                        nodeControllerService.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            stopNCThreads.add(ncStopThread);
            ncStopThread.start();
        }
        for (Thread thread : stopNCThreads) {
            thread.join();
        }
        this.stopCC(false);
        if (deleteOldInstanceData) {
            this.deleteTransactionLogs();
            this.removeTestStorageFiles();
        }
    }

    public void stopCC(boolean terminateNCService) throws Exception {
        if (this.cc != null) {
            this.cc.stop(terminateNCService);
            this.cc = null;
        }
    }

    public static void setStoragePath(String path) {
        storagePath = path;
    }

    public static void restoreDefaultStoragePath() {
        storagePath = DEFAULT_STORAGE_PATH;
    }

    protected String getDefaultStoragePath() {
        return storagePath;
    }

    public void removeTestStorageFiles() {
        File dir = new File(this.getDefaultStoragePath());
        for (String ncName : this.nodeNames) {
            File ncDir = new File(dir, ncName);
            FileUtils.deleteQuietly((File)ncDir);
        }
    }

    private void deleteTransactionLogs() throws IOException, AsterixException {
        for (String ncId : this.nodeNames) {
            File log = new File((String)PropertiesAccessor.getInstance((IApplicationConfig)this.configManager.getAppConfig()).getTransactionLogDirs().get(ncId));
            if (!log.exists()) continue;
            FileUtils.deleteDirectory((File)log);
        }
    }

    public static void main(String[] args) throws Exception {
        AsterixHyracksIntegrationUtil integrationUtil = new AsterixHyracksIntegrationUtil();
        try {
            integrationUtil.run(Boolean.getBoolean("cleanup.start"), Boolean.getBoolean("cleanup.shutdown"));
        }
        catch (Exception e) {
            LoggerHolder.LOGGER.log(Level.WARNING, "Unexpected exception", e);
            System.exit(1);
        }
    }

    protected void run(boolean cleanupOnStart, final boolean cleanupOnShutdown) throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AsterixHyracksIntegrationUtil.this.deinit(cleanupOnShutdown);
                }
                catch (Exception e) {
                    LoggerHolder.LOGGER.log(Level.WARNING, "Unexpected exception on shutdown", e);
                }
            }
        });
        System.setProperty("AsterixConfigFileName", "asterix-build-configuration.xml");
        this.init(cleanupOnStart);
        while (true) {
            Thread.sleep(10000L);
        }
    }

    static {
        storagePath = DEFAULT_STORAGE_PATH = FileUtil.joinPath((String[])new String[]{"target", "io", "dir"});
    }

    static class LoggerHolder {
        static final Logger LOGGER = Logger.getLogger(AsterixHyracksIntegrationUtil.class.getName());

        private LoggerHolder() {
        }
    }
}

