/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.utils;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;

public class ComponentMetadataUtil {
    public static final MutableArrayValueReference MARKER_LSN_KEY = new MutableArrayValueReference("Marker".getBytes());
    public static final long NOT_FOUND = -1L;

    private ComponentMetadataUtil() {
    }

    public static long getLong(IComponentMetadata metadata, IValueReference key, long defaultValue) throws HyracksDataException {
        IValueReference value = metadata.get(key);
        return value == null || value.getLength() == 0 ? defaultValue : LongPointable.getLong((byte[])value.getByteArray(), (int)value.getStartOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(ILSMIndex index, IValueReference key, IPointable pointable) throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = index.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            index.getCurrentMemoryComponent().getMetadata().get(key, pointable);
            if (pointable.getLength() == 0) {
                ComponentMetadataUtil.fromImmutableMemoryComponents(index, key, pointable);
                if (pointable.getLength() == 0) {
                    ComponentMetadataUtil.fromDiskComponents(index, key, pointable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ILSMIndex index, IValueReference key, IPointable pointable) throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = index.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            index.getCurrentMemoryComponent().getMetadata().put(key, (IValueReference)pointable);
        }
    }

    private static void fromDiskComponents(ILSMIndex index, IValueReference key, IPointable pointable) throws HyracksDataException {
        for (ILSMDiskComponent c : index.getImmutableComponents()) {
            c.getMetadata().get(key, pointable);
            if (pointable.getLength() == 0) continue;
            return;
        }
    }

    private static void fromImmutableMemoryComponents(ILSMIndex index, IValueReference key, IPointable pointable) {
        List<ILSMMemoryComponent> memComponents = index.getMemoryComponents();
        int numOtherMemComponents = memComponents.size() - 1;
        int next = index.getCurrentMemoryComponentIndex();
        for (int i = 0; i < numOtherMemComponents; ++i) {
            ILSMMemoryComponent c;
            if (--next < 0) {
                next = memComponents.size() - 1;
            }
            if (!(c = index.getMemoryComponents().get(next)).isReadable()) continue;
            c.getMetadata().get(key, pointable);
            if (pointable.getLength() == 0) continue;
            return;
        }
    }
}

