/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterReference;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMComponentFilterManager
implements ILSMComponentFilterManager {
    public static final MutableArrayValueReference FILTER_KEY = new MutableArrayValueReference("Filter".getBytes());
    private final ILSMComponentFilterFrameFactory filterFrameFactory;

    public LSMComponentFilterManager(ILSMComponentFilterFrameFactory filterFrameFactory) {
        this.filterFrameFactory = filterFrameFactory;
    }

    @Override
    public void updateFilter(ILSMComponentFilter filter, List<ITupleReference> filterTuples) throws HyracksDataException {
        MultiComparator filterCmp = MultiComparator.create((IBinaryComparatorFactory[])filter.getFilterCmpFactories());
        for (ITupleReference tuple : filterTuples) {
            filter.update(tuple, filterCmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFilter(ILSMComponentFilter filter, ITreeIndex treeIndex) throws HyracksDataException {
        IMetadataPageManager treeMetaManager = (IMetadataPageManager)treeIndex.getPageManager();
        ILSMComponentFilterReference filterFrame = this.filterFrameFactory.createFrame();
        try {
            if (filter.getMinTuple() != null) {
                filterFrame.writeMinTuple(filter.getMinTuple());
            }
            if (filter.getMaxTuple() != null) {
                filterFrame.writeMaxTuple(filter.getMaxTuple());
            }
        }
        finally {
            treeMetaManager.put(treeMetaManager.createMetadataFrame(), (IValueReference)FILTER_KEY, (IValueReference)filterFrame);
        }
    }

    @Override
    public boolean readFilter(ILSMComponentFilter filter, ITreeIndex treeIndex) throws HyracksDataException {
        IMetadataPageManager treeMetaManager = (IMetadataPageManager)treeIndex.getPageManager();
        ILSMComponentFilterReference filterFrame = this.filterFrameFactory.createFrame();
        treeMetaManager.get(treeMetaManager.createMetadataFrame(), (IValueReference)FILTER_KEY, (IPointable)filterFrame);
        if (!filterFrame.isMinTupleSet() || !filterFrame.isMaxTupleSet()) {
            return false;
        }
        ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
        filterTuples.add(filterFrame.getMinTuple());
        filterTuples.add(filterFrame.getMaxTuple());
        this.updateFilter(filter, filterTuples);
        return true;
    }
}

