/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndex;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleWriter;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class AbstractLSMDiskComponentBulkLoader
implements ILSMDiskComponentBulkLoader {
    protected final ILSMDiskComponent component;
    protected final IIndexBulkLoader indexBulkLoader;
    protected final IIndexBulkLoader bloomFilterBuilder;
    protected final ILSMComponentFilterManager filterManager;
    protected final PermutingTupleReference indexTuple;
    protected final PermutingTupleReference filterTuple;
    protected final MultiComparator filterCmp;
    protected final boolean cleanupEmptyComponent;
    protected boolean cleanedUpArtifacts = false;
    protected boolean isEmptyComponent = true;
    protected boolean endedBloomFilterLoad = false;

    public AbstractLSMDiskComponentBulkLoader(ILSMDiskComponent component, BloomFilterSpecification bloomFilterSpec, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean cleanupEmptyComponent, ILSMComponentFilterManager filterManager, int[] indexFields, int[] filterFields, MultiComparator filterCmp) throws HyracksDataException {
        this.component = component;
        this.indexBulkLoader = this.getIndex(component).createBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex);
        this.bloomFilterBuilder = bloomFilterSpec != null ? this.getBloomFilter(component).createBuilder(numElementsHint, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements()) : null;
        this.cleanupEmptyComponent = cleanupEmptyComponent;
        if (filterManager != null) {
            this.filterManager = filterManager;
            this.indexTuple = new PermutingTupleReference(indexFields);
            this.filterTuple = new PermutingTupleReference(filterFields);
            this.filterCmp = filterCmp;
        } else {
            this.filterManager = null;
            this.indexTuple = null;
            this.filterTuple = null;
            this.filterCmp = null;
        }
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        try {
            ITupleReference t;
            if (this.indexTuple != null) {
                this.indexTuple.reset(tuple);
                t = this.indexTuple;
            } else {
                t = tuple;
            }
            this.indexBulkLoader.add(t);
            if (this.bloomFilterBuilder != null) {
                this.bloomFilterBuilder.add(t);
            }
            this.updateFilter(tuple);
        }
        catch (Exception e) {
            this.cleanupArtifacts();
            throw e;
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    @Override
    public void delete(ITupleReference tuple) throws HyracksDataException {
        ILSMTreeTupleWriter tupleWriter = (ILSMTreeTupleWriter)((AbstractTreeIndex.AbstractTreeIndexBulkLoader)this.indexBulkLoader).getLeafFrame().getTupleWriter();
        tupleWriter.setAntimatter(true);
        try {
            ITupleReference t;
            if (this.indexTuple != null) {
                this.indexTuple.reset(tuple);
                t = this.indexTuple;
            } else {
                t = tuple;
            }
            this.indexBulkLoader.add(t);
            this.updateFilter(tuple);
        }
        catch (Exception e) {
            this.cleanupArtifacts();
            throw e;
        }
        finally {
            tupleWriter.setAntimatter(false);
        }
        if (this.isEmptyComponent) {
            this.isEmptyComponent = false;
        }
    }

    public void abort() throws HyracksDataException {
        if (this.indexBulkLoader != null) {
            this.indexBulkLoader.abort();
        }
        if (this.bloomFilterBuilder != null) {
            this.bloomFilterBuilder.abort();
        }
    }

    public void end() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            if (this.bloomFilterBuilder != null && !this.endedBloomFilterLoad) {
                this.bloomFilterBuilder.end();
                this.endedBloomFilterLoad = true;
            }
            if (this.filterManager != null && this.component.getLSMComponentFilter() != null) {
                this.filterManager.writeFilter(this.component.getLSMComponentFilter(), this.getTreeIndex(this.component));
            }
            this.indexBulkLoader.end();
            if (this.isEmptyComponent && this.cleanupEmptyComponent) {
                this.cleanupArtifacts();
            }
        }
    }

    protected void cleanupArtifacts() throws HyracksDataException {
        if (!this.cleanedUpArtifacts) {
            this.cleanedUpArtifacts = true;
            if (this.bloomFilterBuilder != null && !this.endedBloomFilterLoad) {
                this.bloomFilterBuilder.abort();
                this.endedBloomFilterLoad = true;
            }
            this.getIndex(this.component).deactivate();
            this.getIndex(this.component).destroy();
            if (this.bloomFilterBuilder != null) {
                this.getBloomFilter(this.component).deactivate();
                this.getBloomFilter(this.component).destroy();
            }
        }
    }

    protected void updateFilter(ITupleReference tuple) throws HyracksDataException {
        if (this.filterTuple != null) {
            this.filterTuple.reset(tuple);
            this.component.getLSMComponentFilter().update((ITupleReference)this.filterTuple, this.filterCmp);
        }
    }

    protected ITreeIndex getTreeIndex(ILSMDiskComponent component) {
        return (ITreeIndex)this.getIndex(component);
    }

    protected abstract IIndex getIndex(ILSMDiskComponent var1);

    protected abstract BloomFilter getBloomFilter(ILSMDiskComponent var1);
}

