/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMDiskComponentId;
import org.apache.hyracks.storage.am.lsm.common.utils.ComponentMetadataUtil;

public abstract class AbstractLSMDiskComponent
extends AbstractLSMComponent
implements ILSMDiskComponent {
    private final DiskComponentMetadata metadata;

    public AbstractLSMDiskComponent(IMetadataPageManager mdPageManager, ILSMComponentFilter filter) {
        super(filter);
        this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
        this.metadata = new DiskComponentMetadata(mdPageManager);
    }

    @Override
    public boolean threadEnter(LSMOperationType opType, boolean isMutableComponent) {
        if (this.state == ILSMComponent.ComponentState.INACTIVE) {
            throw new IllegalStateException("Trying to enter an inactive disk component");
        }
        switch (opType) {
            case FORCE_MODIFICATION: 
            case MODIFICATION: 
            case REPLICATE: 
            case SEARCH: 
            case DISK_COMPONENT_SCAN: {
                ++this.readerCount;
                break;
            }
            case MERGE: {
                if (this.state == ILSMComponent.ComponentState.READABLE_MERGING) {
                    return false;
                }
                this.state = ILSMComponent.ComponentState.READABLE_MERGING;
                ++this.readerCount;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + (Object)((Object)opType));
            }
        }
        return true;
    }

    @Override
    public void threadExit(LSMOperationType opType, boolean failedOperation, boolean isMutableComponent) throws HyracksDataException {
        switch (opType) {
            case MERGE: {
                if (failedOperation) {
                    this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
                }
            }
            case FORCE_MODIFICATION: 
            case MODIFICATION: 
            case REPLICATE: 
            case SEARCH: 
            case DISK_COMPONENT_SCAN: {
                --this.readerCount;
                if (this.readerCount != 0 || this.state != ILSMComponent.ComponentState.READABLE_MERGING) break;
                this.state = ILSMComponent.ComponentState.INACTIVE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + (Object)((Object)opType));
            }
        }
        if (this.readerCount <= -1) {
            throw new IllegalStateException("Invalid LSM disk component readerCount: " + this.readerCount);
        }
    }

    @Override
    public DiskComponentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ILSMDiskComponentId getComponentId() throws HyracksDataException {
        long minID = ComponentMetadataUtil.getLong(this.metadata, (IValueReference)ILSMDiskComponentId.COMPONENT_ID_MIN_KEY, -1L);
        long maxID = ComponentMetadataUtil.getLong(this.metadata, (IValueReference)ILSMDiskComponentId.COMPONENT_ID_MAX_KEY, -1L);
        return new LSMDiskComponentId(minID, maxID);
    }
}

