/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;

public class NotifyTaskFailureWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(NotifyTaskFailureWork.class.getName());
    private final NodeControllerService ncs;
    private final Task task;
    private final JobId jobId;
    private final TaskAttemptId taskId;
    private final List<Exception> exceptions;

    public NotifyTaskFailureWork(NodeControllerService ncs, Task task, List<Exception> exceptions, JobId jobId, TaskAttemptId taskId) {
        this.ncs = ncs;
        this.task = task;
        this.exceptions = exceptions;
        this.jobId = jobId;
        this.taskId = taskId;
    }

    public void run() {
        try {
            IDatasetPartitionManager dpm = this.ncs.getDatasetPartitionManager();
            if (dpm != null) {
                dpm.abortReader(this.jobId);
            }
            this.ncs.getClusterController().notifyTaskFailure(this.jobId, this.taskId, this.ncs.getId(), this.exceptions);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failure reporting task failure to cluster controller", e);
        }
        if (this.task != null) {
            this.task.getJoblet().removeTask(this.task);
        }
    }
}

