/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.application.NCServiceContext;

public class ApplicationMessageWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMessageWork.class.getName());
    private byte[] message;
    private DeploymentId deploymentId;
    private String nodeId;
    private NodeControllerService ncs;

    public ApplicationMessageWork(NodeControllerService ncs, byte[] message, DeploymentId deploymentId, String nodeId) {
        this.ncs = ncs;
        this.deploymentId = deploymentId;
        this.nodeId = nodeId;
        this.message = message;
    }

    public void run() {
        NCServiceContext ctx = this.ncs.getContext();
        try {
            IMessage data = (IMessage)DeploymentUtils.deserialize((byte[])this.message, (DeploymentId)this.deploymentId, (IServiceContext)ctx);
            if (ctx.getMessageBroker() != null) {
                ctx.getMessageBroker().receivedMessage(data, this.nodeId);
            } else {
                LOGGER.log(Level.WARNING, "Message was sent, but no Message Broker set!");
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Error in application message delivery!", e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getName() + ": nodeID: " + this.nodeId;
    }
}

