/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.partitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.IPartition;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.comm.channels.NetworkOutputChannel;
import org.apache.hyracks.control.common.job.PartitionDescriptor;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.DefaultDeallocatableRegistry;

public class PartitionManager {
    private final NodeControllerService ncs;
    private final Map<PartitionId, List<IPartition>> availablePartitionMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;
    private final Map<PartitionId, NetworkOutputChannel> partitionRequests = new HashMap<PartitionId, NetworkOutputChannel>();

    public PartitionManager(NodeControllerService ncs) {
        this.ncs = ncs;
        this.availablePartitionMap = new HashMap<PartitionId, List<IPartition>>();
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory(this.deallocatableRegistry, ncs.getIoManager());
    }

    public synchronized void registerPartition(PartitionId pid, TaskAttemptId taId, IPartition partition, PartitionState state, boolean updateToCC) throws HyracksDataException {
        try {
            List<IPartition> pList;
            NetworkOutputChannel writer = this.partitionRequests.remove(pid);
            if (writer != null) {
                writer.setFrameSize(partition.getTaskContext().getInitialFrameSize());
                partition.writeTo((IFrameWriter)writer);
                if (!partition.isReusable()) {
                    return;
                }
            }
            if ((pList = this.availablePartitionMap.get(pid)) == null) {
                pList = new ArrayList<IPartition>();
                this.availablePartitionMap.put(pid, pList);
            }
            pList.add(partition);
            if (updateToCC) {
                this.updatePartitionState(pid, taId, partition, state);
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public synchronized IPartition getPartition(PartitionId pid) {
        return this.availablePartitionMap.get(pid).get(0);
    }

    public synchronized void unregisterPartitions(JobId jobId, Collection<IPartition> unregisteredPartitions) {
        Iterator<Map.Entry<PartitionId, List<IPartition>>> i = this.availablePartitionMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<PartitionId, List<IPartition>> e = i.next();
            PartitionId pid = e.getKey();
            if (!jobId.equals((Object)pid.getJobId())) continue;
            for (IPartition p : e.getValue()) {
                unregisteredPartitions.add(p);
            }
            i.remove();
        }
    }

    public synchronized void registerPartitionRequest(PartitionId partitionId, NetworkOutputChannel writer) throws HyracksException {
        try {
            List<IPartition> pList = this.availablePartitionMap.get(partitionId);
            if (pList != null && !pList.isEmpty()) {
                IPartition partition = pList.get(0);
                writer.setFrameSize(partition.getTaskContext().getInitialFrameSize());
                partition.writeTo((IFrameWriter)writer);
                if (!partition.isReusable()) {
                    this.availablePartitionMap.remove(partitionId);
                }
            } else {
                this.partitionRequests.put(partitionId, writer);
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public IWorkspaceFileFactory getFileFactory() {
        return this.fileFactory;
    }

    public void close() {
        this.deallocatableRegistry.close();
    }

    public void updatePartitionState(PartitionId pid, TaskAttemptId taId, IPartition partition, PartitionState state) throws HyracksDataException {
        PartitionDescriptor desc = new PartitionDescriptor(pid, this.ncs.getId(), taId, partition.isReusable());
        desc.setState(state);
        try {
            this.ncs.getClusterController().registerPartitionProvider(desc);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

