/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.partitions;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.partitions.IPartition;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.nc.partitions.PartitionManager;

public class MaterializingPipelinedPartition
implements IFrameWriter,
IPartition {
    private static final Logger LOGGER = Logger.getLogger(MaterializingPipelinedPartition.class.getName());
    private final IHyracksTaskContext ctx;
    private final Executor executor;
    private final IIOManager ioManager;
    private final PartitionManager manager;
    private final PartitionId pid;
    private final TaskAttemptId taId;
    private FileReference fRef;
    private IFileHandle writeHandle;
    private long size;
    private boolean eos;
    private boolean failed;
    protected boolean flushRequest;
    private Level openCloseLevel = Level.FINE;
    private Thread dataConsumerThread;

    public MaterializingPipelinedPartition(IHyracksTaskContext ctx, PartitionManager manager, PartitionId pid, TaskAttemptId taId, Executor executor) {
        this.ctx = ctx;
        this.executor = executor;
        this.ioManager = ctx.getIoManager();
        this.manager = manager;
        this.pid = pid;
        this.taId = taId;
    }

    public IHyracksTaskContext getTaskContext() {
        return this.ctx;
    }

    public synchronized void deallocate() {
        if (this.dataConsumerThread != null) {
            this.dataConsumerThread.interrupt();
        }
    }

    public void writeTo(final IFrameWriter writer) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                MaterializingPipelinedPartition.this.setDataConsumerThread(thread);
                String oldName = thread.getName();
                try {
                    FileReference fRefCopy;
                    thread.setName(MaterializingPipelinedPartition.class.getName() + MaterializingPipelinedPartition.this.pid);
                    MaterializingPipelinedPartition materializingPipelinedPartition = MaterializingPipelinedPartition.this;
                    synchronized (materializingPipelinedPartition) {
                        while (MaterializingPipelinedPartition.this.fRef == null && !MaterializingPipelinedPartition.this.eos && !MaterializingPipelinedPartition.this.failed) {
                            MaterializingPipelinedPartition.this.wait();
                        }
                        fRefCopy = MaterializingPipelinedPartition.this.fRef;
                    }
                    writer.open();
                    IFileHandle readHandle = fRefCopy == null ? null : MaterializingPipelinedPartition.this.ioManager.open(fRefCopy, IIOManager.FileReadWriteMode.READ_ONLY, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
                    try {
                        if (readHandle == null) {
                            return;
                        }
                        long offset = 0L;
                        ByteBuffer buffer = MaterializingPipelinedPartition.this.ctx.allocateFrame();
                        boolean done = false;
                        while (!done) {
                            boolean fail;
                            boolean flush;
                            MaterializingPipelinedPartition materializingPipelinedPartition2 = MaterializingPipelinedPartition.this;
                            synchronized (materializingPipelinedPartition2) {
                                while (offset >= MaterializingPipelinedPartition.this.size && !MaterializingPipelinedPartition.this.eos && !MaterializingPipelinedPartition.this.failed) {
                                    MaterializingPipelinedPartition.this.wait();
                                }
                                flush = MaterializingPipelinedPartition.this.flushRequest;
                                MaterializingPipelinedPartition.this.flushRequest = false;
                                fail = MaterializingPipelinedPartition.this.failed;
                                done = MaterializingPipelinedPartition.this.eos && offset >= MaterializingPipelinedPartition.this.size;
                            }
                            if (fail) {
                                writer.fail();
                                break;
                            }
                            if (!done) {
                                buffer.clear();
                                long readLen = MaterializingPipelinedPartition.this.ioManager.syncRead(readHandle, offset, buffer);
                                if (readLen < (long)buffer.capacity()) {
                                    throw new HyracksDataException("Premature end of file");
                                }
                                offset += readLen;
                                buffer.flip();
                                writer.nextFrame(buffer);
                            }
                            if (!flush) continue;
                            writer.flush();
                        }
                    }
                    catch (Exception e) {
                        writer.fail();
                        throw e;
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        finally {
                            try {
                                if (readHandle != null) {
                                    MaterializingPipelinedPartition.this.ioManager.close(readHandle);
                                }
                            }
                            finally {
                                if (MaterializingPipelinedPartition.this.fRef != null) {
                                    MaterializingPipelinedPartition.this.fRef.delete();
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                finally {
                    thread.setName(oldName);
                    MaterializingPipelinedPartition.this.setDataConsumerThread(null);
                }
            }
        });
    }

    public boolean isReusable() {
        return true;
    }

    public void open() throws HyracksDataException {
        if (LOGGER.isLoggable(this.openCloseLevel)) {
            LOGGER.log(this.openCloseLevel, "open(" + this.pid + " by " + this.taId);
        }
        this.size = 0L;
        this.eos = false;
        this.failed = false;
        this.manager.registerPartition(this.pid, this.taId, this, PartitionState.STARTED, false);
    }

    private void checkOrCreateFile() throws HyracksDataException {
        if (this.fRef == null) {
            this.fRef = this.manager.getFileFactory().createUnmanagedWorkspaceFile(this.pid.toString().replace(":", "$"));
            this.writeHandle = this.ioManager.open(this.fRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        }
    }

    public synchronized void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.checkOrCreateFile();
        this.size += (long)this.ctx.getIoManager().syncWrite(this.writeHandle, this.size, buffer);
        this.notifyAll();
    }

    public synchronized void fail() throws HyracksDataException {
        this.failed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HyracksDataException {
        if (LOGGER.isLoggable(this.openCloseLevel)) {
            LOGGER.log(this.openCloseLevel, "close(" + this.pid + " by " + this.taId);
        }
        if (this.writeHandle != null) {
            this.ctx.getIoManager().close(this.writeHandle);
        }
        MaterializingPipelinedPartition materializingPipelinedPartition = this;
        synchronized (materializingPipelinedPartition) {
            this.eos = true;
            this.writeHandle = null;
            this.notifyAll();
        }
    }

    public synchronized void flush() throws HyracksDataException {
        this.flushRequest = true;
        this.notifyAll();
    }

    private synchronized void setDataConsumerThread(Thread thread) {
        this.dataConsumerThread = thread;
    }
}

