/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.lifecycle.LifeCycleComponentManager;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.heartbeat.HeartbeatSchema;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.ipc.ClusterControllerRemoteProxy;
import org.apache.hyracks.control.common.ipc.IControllerRemoteProxyIPCEventListener;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.utils.PidHelper;
import org.apache.hyracks.control.common.work.FutureValue;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.common.work.WorkQueue;
import org.apache.hyracks.control.nc.BaseNCApplication;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NCShutdownHook;
import org.apache.hyracks.control.nc.NodeControllerIPCI;
import org.apache.hyracks.control.nc.application.NCServiceContext;
import org.apache.hyracks.control.nc.dataset.DatasetPartitionManager;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.control.nc.io.profiling.IIOCounter;
import org.apache.hyracks.control.nc.io.profiling.IOCounterFactory;
import org.apache.hyracks.control.nc.net.DatasetNetworkManager;
import org.apache.hyracks.control.nc.net.MessagingNetworkManager;
import org.apache.hyracks.control.nc.net.NetworkManager;
import org.apache.hyracks.control.nc.partitions.PartitionManager;
import org.apache.hyracks.control.nc.resources.memory.MemoryManager;
import org.apache.hyracks.control.nc.work.BuildJobProfilesWork;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPCPerformanceCounters;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.net.protocols.muxdemux.FullFrameChannelInterfaceFactory;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import org.kohsuke.args4j.CmdLineException;

public class NodeControllerService
implements IControllerService {
    private static final Logger LOGGER = Logger.getLogger(NodeControllerService.class.getName());
    private static final double MEMORY_FUDGE_FACTOR = 0.8;
    private NCConfig ncConfig;
    private final String id;
    private final IOManager ioManager;
    private IPCSystem ipc;
    private PartitionManager partitionManager;
    private NetworkManager netManager;
    private IDatasetPartitionManager datasetPartitionManager;
    private DatasetNetworkManager datasetNetworkManager;
    private final WorkQueue workQueue;
    private final Timer timer;
    private boolean registrationPending;
    private Exception registrationException;
    private IClusterController ccs;
    private final Map<JobId, Joblet> jobletMap;
    private final Map<JobId, ActivityClusterGraph> preDistributedJobActivityClusterGraphMap;
    private ExecutorService executor;
    private NodeParameters nodeParameters;
    private HeartbeatTask heartbeatTask;
    private final ServerContext serverCtx;
    private NCServiceContext serviceCtx;
    private final INCApplication application;
    private final ILifeCycleComponentManager lccm;
    private final MemoryMXBean memoryMXBean;
    private final List<GarbageCollectorMXBean> gcMXBeans;
    private final ThreadMXBean threadMXBean;
    private final RuntimeMXBean runtimeMXBean;
    private final OperatingSystemMXBean osMXBean;
    private final Mutable<FutureValue<Map<String, NodeControllerInfo>>> getNodeControllerInfosAcceptor;
    private final MemoryManager memoryManager;
    private boolean shuttedDown = false;
    private IIOCounter ioCounter;
    private MessagingNetworkManager messagingNetManager;
    private final ConfigManager configManager;
    private NodeRegistration nodeRegistration;
    private final AtomicLong maxJobId = new AtomicLong(-1L);

    public NodeControllerService(NCConfig config) throws Exception {
        this(config, NodeControllerService.getApplication(config));
    }

    public NodeControllerService(NCConfig config, INCApplication application) throws IOException, CmdLineException {
        this.ncConfig = config;
        this.configManager = this.ncConfig.getConfigManager();
        if (application == null) {
            throw new IllegalArgumentException("INCApplication cannot be null");
        }
        this.configManager.processConfig();
        this.application = application;
        this.id = this.ncConfig.getNodeId();
        this.ioManager = new IOManager(IODeviceHandle.getDevices((String[])this.ncConfig.getIODevices()), application.getFileDeviceResolver());
        if (this.id == null) {
            throw new HyracksException("id not set");
        }
        this.lccm = new LifeCycleComponentManager();
        this.workQueue = new WorkQueue(this.id, 5);
        this.jobletMap = new Hashtable<JobId, Joblet>();
        this.preDistributedJobActivityClusterGraphMap = new Hashtable<JobId, ActivityClusterGraph>();
        this.timer = new Timer(true);
        this.serverCtx = new ServerContext(ServerContext.ServerType.NODE_CONTROLLER, new File(new File(NodeControllerService.class.getName()), this.id));
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.osMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.getNodeControllerInfosAcceptor = new MutableObject();
        this.memoryManager = new MemoryManager((long)((double)this.memoryMXBean.getHeapMemoryUsage().getMax() * 0.8));
        this.ioCounter = new IOCounterFactory().getIOCounter();
    }

    public IOManager getIoManager() {
        return this.ioManager;
    }

    public NCServiceContext getContext() {
        return this.serviceCtx;
    }

    public ILifeCycleComponentManager getLifeCycleComponentManager() {
        return this.lccm;
    }

    synchronized void setNodeRegistrationResult(NodeParameters parameters, Exception exception) {
        this.nodeParameters = parameters;
        this.registrationException = exception;
        this.registrationPending = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NodeControllerInfo> getNodeControllersInfo() throws Exception {
        FutureValue fv = new FutureValue();
        Mutable<FutureValue<Map<String, NodeControllerInfo>>> mutable = this.getNodeControllerInfosAcceptor;
        synchronized (mutable) {
            while (this.getNodeControllerInfosAcceptor.getValue() != null) {
                this.getNodeControllerInfosAcceptor.wait();
            }
            this.getNodeControllerInfosAcceptor.setValue((Object)fv);
        }
        this.ccs.getNodeControllerInfos();
        return (Map)fv.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodeControllersInfo(Map<String, NodeControllerInfo> ncInfos) {
        FutureValue fv;
        Mutable<FutureValue<Map<String, NodeControllerInfo>>> mutable = this.getNodeControllerInfosAcceptor;
        synchronized (mutable) {
            fv = (FutureValue)this.getNodeControllerInfosAcceptor.getValue();
            this.getNodeControllerInfosAcceptor.setValue(null);
            this.getNodeControllerInfosAcceptor.notifyAll();
        }
        fv.setValue(ncInfos);
    }

    private void init() throws Exception {
        this.ioManager.setExecutor(this.executor);
        this.datasetPartitionManager = new DatasetPartitionManager(this, this.executor, this.ncConfig.getResultManagerMemory(), this.ncConfig.getResultTTL(), this.ncConfig.getResultSweepThreshold());
        this.datasetNetworkManager = new DatasetNetworkManager(this.ncConfig.getResultListenAddress(), this.ncConfig.getResultListenPort(), this.datasetPartitionManager, this.ncConfig.getNetThreadCount(), this.ncConfig.getNetBufferCount(), this.ncConfig.getResultPublicAddress(), this.ncConfig.getResultPublicPort(), FullFrameChannelInterfaceFactory.INSTANCE);
        if (this.ncConfig.getMessagingListenAddress() != null && this.serviceCtx.getMessagingChannelInterfaceFactory() != null) {
            this.messagingNetManager = new MessagingNetworkManager(this, this.ncConfig.getMessagingListenAddress(), this.ncConfig.getMessagingListenPort(), this.ncConfig.getNetThreadCount(), this.ncConfig.getMessagingPublicAddress(), this.ncConfig.getMessagingPublicPort(), this.serviceCtx.getMessagingChannelInterfaceFactory());
        }
    }

    public void start() throws Exception {
        LOGGER.log(Level.INFO, "Starting NodeControllerService");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Setting uncaught exception handler " + this.getLifeCycleComponentManager());
        }
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this.getLifeCycleComponentManager());
        Runtime.getRuntime().addShutdownHook(new NCShutdownHook(this));
        this.ipc = new IPCSystem(new InetSocketAddress(this.ncConfig.getClusterListenAddress(), this.ncConfig.getClusterListenPort()), (IIPCI)new NodeControllerIPCI(this), (IPayloadSerializerDeserializer)new CCNCFunctions.SerializerDeserializer());
        this.ipc.start();
        this.partitionManager = new PartitionManager(this);
        this.netManager = new NetworkManager(this.ncConfig.getDataListenAddress(), this.ncConfig.getDataListenPort(), this.partitionManager, this.ncConfig.getNetThreadCount(), this.ncConfig.getNetBufferCount(), this.ncConfig.getDataPublicAddress(), this.ncConfig.getDataPublicPort(), FullFrameChannelInterfaceFactory.INSTANCE);
        this.netManager.start();
        this.startApplication();
        this.init();
        this.datasetNetworkManager.start();
        if (this.messagingNetManager != null) {
            this.messagingNetManager.start();
        }
        this.ccs = new ClusterControllerRemoteProxy(this.ipc, new InetSocketAddress(this.ncConfig.getClusterAddress(), this.ncConfig.getClusterPort()), this.ncConfig.getClusterConnectRetries(), new IControllerRemoteProxyIPCEventListener(){

            public void ipcHandleRestored(IIPCHandle handle) throws IPCException {
                try {
                    NodeControllerService.this.registerNode();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed Registering with cc", e);
                    throw new IPCException((Throwable)e);
                }
            }
        });
        this.registerNode();
        this.workQueue.start();
        this.heartbeatTask = new HeartbeatTask(this.ccs);
        Field threadField = this.timer.getClass().getDeclaredField("thread");
        threadField.setAccessible(true);
        Thread timerThread = (Thread)threadField.get(this.timer);
        timerThread.setPriority(10);
        this.timer.schedule((TimerTask)this.heartbeatTask, 0L, (long)this.nodeParameters.getHeartbeatPeriod());
        if (this.nodeParameters.getProfileDumpPeriod() > 0) {
            this.timer.schedule((TimerTask)new ProfileDumpTask(this.ccs), 0L, (long)this.nodeParameters.getProfileDumpPeriod());
        }
        LOGGER.log(Level.INFO, "Started NodeControllerService");
        this.application.startupCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNode() throws Exception {
        LOGGER.info("Registering with Cluster Controller");
        this.registrationPending = true;
        HeartbeatSchema.GarbageCollectorInfo[] gcInfos = new HeartbeatSchema.GarbageCollectorInfo[this.gcMXBeans.size()];
        for (int i = 0; i < gcInfos.length; ++i) {
            gcInfos[i] = new HeartbeatSchema.GarbageCollectorInfo(this.gcMXBeans.get(i).getName());
        }
        HeartbeatSchema hbSchema = new HeartbeatSchema(gcInfos);
        NetworkAddress datasetAddress = this.datasetNetworkManager.getPublicNetworkAddress();
        NetworkAddress netAddress = this.netManager.getPublicNetworkAddress();
        NetworkAddress meesagingPort = this.messagingNetManager != null ? this.messagingNetManager.getPublicNetworkAddress() : null;
        int allCores = this.osMXBean.getAvailableProcessors();
        this.nodeRegistration = new NodeRegistration(this.ipc.getSocketAddress(), this.id, this.ncConfig, netAddress, datasetAddress, this.osMXBean.getName(), this.osMXBean.getArch(), this.osMXBean.getVersion(), allCores, this.runtimeMXBean.getVmName(), this.runtimeMXBean.getVmVersion(), this.runtimeMXBean.getVmVendor(), this.runtimeMXBean.getClassPath(), this.runtimeMXBean.getLibraryPath(), this.runtimeMXBean.getBootClassPath(), this.runtimeMXBean.getInputArguments(), this.runtimeMXBean.getSystemProperties(), hbSchema, meesagingPort, this.application.getCapacity(), PidHelper.getPid(), this.maxJobId.get());
        this.ccs.registerNode(this.nodeRegistration);
        NodeControllerService nodeControllerService = this;
        synchronized (nodeControllerService) {
            while (this.registrationPending) {
                this.wait();
            }
        }
        if (this.registrationException != null) {
            LOGGER.log(Level.WARNING, "Registering with Cluster Controller failed with exception", this.registrationException);
            throw this.registrationException;
        }
        this.serviceCtx.setDistributedState(this.nodeParameters.getDistributedState());
        this.application.onRegisterNode();
        LOGGER.info("Registering with Cluster Controller complete");
    }

    private void startApplication() throws Exception {
        this.serviceCtx = new NCServiceContext(this, this.serverCtx, this.ioManager, this.id, this.memoryManager, this.lccm, this.ncConfig.getAppConfig());
        this.application.start((IServiceContext)this.serviceCtx, this.ncConfig.getAppArgsArray());
        this.executor = Executors.newCachedThreadPool(this.serviceCtx.getThreadFactory());
    }

    public void updateMaxJobId(JobId jobId) {
        this.maxJobId.getAndUpdate(currentMaxId -> Math.max(currentMaxId, jobId.getId()));
    }

    public synchronized void stop() throws Exception {
        if (!this.shuttedDown) {
            LOGGER.log(Level.INFO, "Stopping NodeControllerService");
            this.application.preStop();
            this.executor.shutdownNow();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOGGER.log(Level.SEVERE, "Some jobs failed to exit, continuing with abnormal shutdown");
            }
            this.partitionManager.close();
            this.datasetPartitionManager.close();
            this.netManager.stop();
            this.datasetNetworkManager.stop();
            if (this.messagingNetManager != null) {
                this.messagingNetManager.stop();
            }
            this.workQueue.stop();
            this.application.stop();
            this.heartbeatTask.cancel();
            LOGGER.log(Level.INFO, "Stopped NodeControllerService");
            this.shuttedDown = true;
        }
    }

    public String getId() {
        return this.id;
    }

    public ServerContext getServerContext() {
        return this.serverCtx;
    }

    public Map<JobId, Joblet> getJobletMap() {
        return this.jobletMap;
    }

    public void storeActivityClusterGraph(JobId jobId, ActivityClusterGraph acg) throws HyracksException {
        if (this.preDistributedJobActivityClusterGraphMap.get(jobId) != null) {
            throw HyracksException.create((int)22, (Serializable[])new Serializable[]{jobId});
        }
        this.preDistributedJobActivityClusterGraphMap.put(jobId, acg);
    }

    public void removeActivityClusterGraph(JobId jobId) throws HyracksException {
        if (this.preDistributedJobActivityClusterGraphMap.get(jobId) == null) {
            throw HyracksException.create((int)21, (Serializable[])new Serializable[]{jobId});
        }
        this.preDistributedJobActivityClusterGraphMap.remove(jobId);
    }

    public void checkForDuplicateDistributedJob(JobId jobId) throws HyracksException {
        if (this.preDistributedJobActivityClusterGraphMap.get(jobId) != null) {
            throw HyracksException.create((int)22, (Serializable[])new Serializable[]{jobId});
        }
    }

    public ActivityClusterGraph getActivityClusterGraph(JobId jobId) throws HyracksException {
        return this.preDistributedJobActivityClusterGraphMap.get(jobId);
    }

    public NetworkManager getNetworkManager() {
        return this.netManager;
    }

    public DatasetNetworkManager getDatasetNetworkManager() {
        return this.datasetNetworkManager;
    }

    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public IClusterController getClusterController() {
        return this.ccs;
    }

    public NodeParameters getNodeParameters() {
        return this.nodeParameters;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public NCConfig getConfiguration() {
        return this.ncConfig;
    }

    public WorkQueue getWorkQueue() {
        return this.workQueue;
    }

    public ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    public void sendApplicationMessageToCC(byte[] data, DeploymentId deploymentId) throws Exception {
        this.ccs.sendApplicationMessageToCC(data, deploymentId, this.id);
    }

    public IDatasetPartitionManager getDatasetPartitionManager() {
        return this.datasetPartitionManager;
    }

    public MessagingNetworkManager getMessagingNetworkManager() {
        return this.messagingNetManager;
    }

    private static INCApplication getApplication(NCConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (config.getAppClass() != null) {
            Class<?> c = Class.forName(config.getAppClass());
            return (INCApplication)c.newInstance();
        }
        return BaseNCApplication.INSTANCE;
    }

    public Object getApplicationContext() {
        return this.application.getApplicationContext();
    }

    private class ProfileDumpTask
    extends TimerTask {
        private IClusterController cc;

        public ProfileDumpTask(IClusterController cc) {
            this.cc = cc;
        }

        @Override
        public void run() {
            try {
                FutureValue fv = new FutureValue();
                BuildJobProfilesWork bjpw = new BuildJobProfilesWork(NodeControllerService.this, (FutureValue<List<JobProfile>>)fv);
                NodeControllerService.this.workQueue.scheduleAndSync((SynchronizableWork)bjpw);
                List profiles = (List)fv.get();
                if (!profiles.isEmpty()) {
                    this.cc.reportProfile(NodeControllerService.this.id, profiles);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception reporting profile", e);
            }
        }
    }

    private class HeartbeatTask
    extends TimerTask {
        private IClusterController cc;
        private final HeartbeatData hbData;

        public HeartbeatTask(IClusterController cc) {
            this.cc = cc;
            this.hbData = new HeartbeatData();
            this.hbData.gcCollectionCounts = new long[NodeControllerService.this.gcMXBeans.size()];
            this.hbData.gcCollectionTimes = new long[NodeControllerService.this.gcMXBeans.size()];
        }

        @Override
        public void run() {
            MemoryUsage heapUsage = NodeControllerService.this.memoryMXBean.getHeapMemoryUsage();
            this.hbData.heapInitSize = heapUsage.getInit();
            this.hbData.heapUsedSize = heapUsage.getUsed();
            this.hbData.heapCommittedSize = heapUsage.getCommitted();
            this.hbData.heapMaxSize = heapUsage.getMax();
            MemoryUsage nonheapUsage = NodeControllerService.this.memoryMXBean.getNonHeapMemoryUsage();
            this.hbData.nonheapInitSize = nonheapUsage.getInit();
            this.hbData.nonheapUsedSize = nonheapUsage.getUsed();
            this.hbData.nonheapCommittedSize = nonheapUsage.getCommitted();
            this.hbData.nonheapMaxSize = nonheapUsage.getMax();
            this.hbData.threadCount = NodeControllerService.this.threadMXBean.getThreadCount();
            this.hbData.peakThreadCount = NodeControllerService.this.threadMXBean.getPeakThreadCount();
            this.hbData.totalStartedThreadCount = NodeControllerService.this.threadMXBean.getTotalStartedThreadCount();
            this.hbData.systemLoadAverage = NodeControllerService.this.osMXBean.getSystemLoadAverage();
            int gcN = NodeControllerService.this.gcMXBeans.size();
            for (int i = 0; i < gcN; ++i) {
                GarbageCollectorMXBean gcMXBean = (GarbageCollectorMXBean)NodeControllerService.this.gcMXBeans.get(i);
                this.hbData.gcCollectionCounts[i] = gcMXBean.getCollectionCount();
                this.hbData.gcCollectionTimes[i] = gcMXBean.getCollectionTime();
            }
            MuxDemuxPerformanceCounters netPC = NodeControllerService.this.netManager.getPerformanceCounters();
            this.hbData.netPayloadBytesRead = netPC.getPayloadBytesRead();
            this.hbData.netPayloadBytesWritten = netPC.getPayloadBytesWritten();
            this.hbData.netSignalingBytesRead = netPC.getSignalingBytesRead();
            this.hbData.netSignalingBytesWritten = netPC.getSignalingBytesWritten();
            MuxDemuxPerformanceCounters datasetNetPC = NodeControllerService.this.datasetNetworkManager.getPerformanceCounters();
            this.hbData.datasetNetPayloadBytesRead = datasetNetPC.getPayloadBytesRead();
            this.hbData.datasetNetPayloadBytesWritten = datasetNetPC.getPayloadBytesWritten();
            this.hbData.datasetNetSignalingBytesRead = datasetNetPC.getSignalingBytesRead();
            this.hbData.datasetNetSignalingBytesWritten = datasetNetPC.getSignalingBytesWritten();
            IPCPerformanceCounters ipcPC = NodeControllerService.this.ipc.getPerformanceCounters();
            this.hbData.ipcMessagesSent = ipcPC.getMessageSentCount();
            this.hbData.ipcMessageBytesSent = ipcPC.getMessageBytesSent();
            this.hbData.ipcMessagesReceived = ipcPC.getMessageReceivedCount();
            this.hbData.ipcMessageBytesReceived = ipcPC.getMessageBytesReceived();
            this.hbData.diskReads = NodeControllerService.this.ioCounter.getReads();
            this.hbData.diskWrites = NodeControllerService.this.ioCounter.getWrites();
            this.hbData.numCores = Runtime.getRuntime().availableProcessors() - 1;
            try {
                this.cc.nodeHeartbeat(NodeControllerService.this.id, this.hbData);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception sending heartbeat", e);
            }
        }
    }
}

