/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.client.dataset;

import java.net.InetSocketAddress;
import org.apache.hyracks.api.dataset.DatasetDirectoryRecord;
import org.apache.hyracks.api.dataset.DatasetJobRecord;
import org.apache.hyracks.api.dataset.IHyracksDatasetDirectoryServiceConnection;
import org.apache.hyracks.api.dataset.IHyracksDatasetDirectoryServiceInterface;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.client.dataset.HyracksDatasetDirectoryServiceInterfaceRemoteProxy;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.api.RPCInterface;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;

public class HyracksDatasetDirectoryServiceConnection
implements IHyracksDatasetDirectoryServiceConnection {
    private final IPCSystem ipc;
    private final IHyracksDatasetDirectoryServiceInterface ddsi;

    public HyracksDatasetDirectoryServiceConnection(String ddsHost, int ddsPort) throws Exception {
        RPCInterface rpci = new RPCInterface();
        this.ipc = new IPCSystem(new InetSocketAddress(0), (IIPCI)rpci, (IPayloadSerializerDeserializer)new JavaSerializationBasedPayloadSerializerDeserializer());
        this.ipc.start();
        IIPCHandle ddsIpchandle = this.ipc.getHandle(new InetSocketAddress(ddsHost, ddsPort));
        this.ddsi = new HyracksDatasetDirectoryServiceInterfaceRemoteProxy(ddsIpchandle, rpci);
    }

    public DatasetJobRecord.Status getDatasetResultStatus(JobId jobId, ResultSetId rsId) throws Exception {
        return this.ddsi.getDatasetResultStatus(jobId, rsId);
    }

    public DatasetDirectoryRecord[] getDatasetResultLocations(JobId jobId, ResultSetId rsId, DatasetDirectoryRecord[] knownRecords) throws Exception {
        return this.ddsi.getDatasetResultLocations(jobId, rsId, knownRecords);
    }
}

