/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.tuples;

import java.util.Arrays;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class ConcatenatingTupleReference
implements ITupleReference {
    private final ITupleReference[] tuples;
    private final int[] fieldCounts;
    private int numTuples;
    private int totalFieldCount;

    public ConcatenatingTupleReference(int maxTuples) {
        this.tuples = new ITupleReference[maxTuples];
        this.fieldCounts = new int[maxTuples];
        this.reset();
    }

    public void reset() {
        this.numTuples = 0;
        this.totalFieldCount = 0;
    }

    public void addTuple(ITupleReference tuple) {
        this.tuples[this.numTuples] = tuple;
        this.totalFieldCount += tuple.getFieldCount();
        this.fieldCounts[this.numTuples] = this.numTuples > 0 ? this.fieldCounts[this.numTuples - 1] + tuple.getFieldCount() : tuple.getFieldCount();
        ++this.numTuples;
    }

    public void removeLastTuple() {
        if (this.numTuples > 0) {
            ITupleReference lastTuple = this.tuples[--this.numTuples];
            this.totalFieldCount -= lastTuple.getFieldCount();
        }
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public boolean hasMaxTuples() {
        return this.numTuples == this.tuples.length;
    }

    public int getFieldCount() {
        return this.totalFieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        int tupleIndex = this.getTupleIndex(fIdx);
        int fieldIndex = this.getFieldIndex(tupleIndex, fIdx);
        return this.tuples[tupleIndex].getFieldData(fieldIndex);
    }

    public int getFieldStart(int fIdx) {
        int tupleIndex = this.getTupleIndex(fIdx);
        int fieldIndex = this.getFieldIndex(tupleIndex, fIdx);
        return this.tuples[tupleIndex].getFieldStart(fieldIndex);
    }

    public int getFieldLength(int fIdx) {
        int tupleIndex = this.getTupleIndex(fIdx);
        int fieldIndex = this.getFieldIndex(tupleIndex, fIdx);
        return this.tuples[tupleIndex].getFieldLength(fieldIndex);
    }

    private int getTupleIndex(int fIdx) {
        int tupleIndex = Arrays.binarySearch(this.fieldCounts, 0, this.numTuples - 1, fIdx);
        tupleIndex = tupleIndex < 0 ? -tupleIndex - 1 : ++tupleIndex;
        return tupleIndex;
    }

    private int getFieldIndex(int tupleIndex, int fIdx) {
        int fieldIndex = -1;
        fieldIndex = tupleIndex > 0 ? fIdx - this.fieldCounts[tupleIndex - 1] : fIdx;
        return fieldIndex;
    }
}

