/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class TreeIndexDiskOrderScanCursor
implements ITreeIndexCursor {
    private int tupleIndex = 0;
    private int fileId = -1;
    private int currentPageId = -1;
    private int maxPageId = -1;
    private ICachedPage page = null;
    private IBufferCache bufferCache = null;
    private final ITreeIndexFrame frame;
    private final ITreeIndexTupleReference frameTuple;

    public TreeIndexDiskOrderScanCursor(ITreeIndexFrame frame) {
        this.frame = frame;
        this.frameTuple = frame.createTupleReference();
    }

    public void close() throws HyracksDataException {
        this.page.releaseReadLatch();
        this.bufferCache.unpin(this.page);
        this.page = null;
    }

    public ITreeIndexTupleReference getTuple() {
        return this.frameTuple;
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }

    private boolean positionToNextLeaf(boolean skipCurrent) throws HyracksDataException {
        while ((this.frame.getLevel() != 0 || skipCurrent || this.frame.getTupleCount() == 0) && ++this.currentPageId <= this.maxPageId) {
            this.page.releaseReadLatch();
            this.bufferCache.unpin(this.page);
            ICachedPage nextPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.currentPageId), false);
            nextPage.acquireReadLatch();
            this.page = nextPage;
            this.frame.setPage(this.page);
            this.tupleIndex = 0;
            skipCurrent = false;
        }
        return this.currentPageId <= this.maxPageId;
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.currentPageId > this.maxPageId) {
            return false;
        }
        if (this.tupleIndex >= this.frame.getTupleCount()) {
            boolean nextLeafExists = this.positionToNextLeaf(true);
            if (nextLeafExists) {
                this.frameTuple.resetByTupleIndex(this.frame, this.tupleIndex);
                return true;
            }
            return false;
        }
        this.frameTuple.resetByTupleIndex(this.frame, this.tupleIndex);
        return true;
    }

    public void next() throws HyracksDataException {
        ++this.tupleIndex;
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page != null) {
            this.page.releaseReadLatch();
            this.bufferCache.unpin(this.page);
        }
        this.page = initialState.getPage();
        this.tupleIndex = 0;
        this.frame.setPage(this.page);
        this.positionToNextLeaf(false);
    }

    public void reset() {
        this.tupleIndex = 0;
        this.currentPageId = -1;
        this.maxPageId = -1;
        this.page = null;
    }

    @Override
    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    @Override
    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public void setCurrentPageId(int currentPageId) {
        this.currentPageId = currentPageId;
    }

    public void setMaxPageId(int maxPageId) {
        this.maxPageId = maxPageId;
    }

    @Override
    public boolean isExclusiveLatchNodes() {
        return false;
    }
}

