/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;

public abstract class IndexSearchOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    static final Logger LOGGER = Logger.getLogger(IndexSearchOperatorNodePushable.class.getName());
    protected final IHyracksTaskContext ctx;
    protected final IIndexDataflowHelper indexHelper;
    protected FrameTupleAccessor accessor;
    protected FrameTupleAppender appender;
    protected ArrayTupleBuilder tb;
    protected DataOutput dos;
    protected IIndex index;
    protected ISearchPredicate searchPred;
    protected IIndexCursor cursor;
    protected IIndexAccessor indexAccessor;
    protected final RecordDescriptor inputRecDesc;
    protected final boolean retainInput;
    protected FrameTupleReference frameTuple;
    protected final boolean retainMissing;
    protected ArrayTupleBuilder nonMatchTupleBuild;
    protected IMissingWriter nonMatchWriter;
    protected final int[] minFilterFieldIndexes;
    protected final int[] maxFilterFieldIndexes;
    protected PermutingFrameTupleReference minFilterKey;
    protected PermutingFrameTupleReference maxFilterKey;
    protected final boolean appendIndexFilter;
    protected ArrayTupleBuilder nonFilterTupleBuild;
    protected final ISearchOperationCallbackFactory searchCallbackFactory;
    protected boolean failed = false;

    public IndexSearchOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, int partition, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, boolean appendIndexFilter) throws HyracksDataException {
        this.ctx = ctx;
        this.indexHelper = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.retainInput = retainInput;
        this.retainMissing = retainMissing;
        this.appendIndexFilter = appendIndexFilter;
        if (this.retainMissing || this.appendIndexFilter) {
            this.nonMatchWriter = missingWriterFactory.createMissingWriter();
        }
        this.inputRecDesc = inputRecDesc;
        this.searchCallbackFactory = searchCallbackFactory;
        this.minFilterFieldIndexes = minFilterFieldIndexes;
        this.maxFilterFieldIndexes = maxFilterFieldIndexes;
        if (minFilterFieldIndexes != null && minFilterFieldIndexes.length > 0) {
            this.minFilterKey = new PermutingFrameTupleReference();
            this.minFilterKey.setFieldPermutation(minFilterFieldIndexes);
        }
        if (maxFilterFieldIndexes != null && maxFilterFieldIndexes.length > 0) {
            this.maxFilterKey = new PermutingFrameTupleReference();
            this.maxFilterKey.setFieldPermutation(maxFilterFieldIndexes);
        }
    }

    protected abstract ISearchPredicate createSearchPredicate();

    protected abstract void resetSearchPredicate(int var1);

    protected IIndexCursor createCursor() {
        return this.indexAccessor.createSearchCursor(false);
    }

    protected abstract int getFieldCount();

    public void open() throws HyracksDataException {
        this.writer.open();
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        if (this.retainMissing) {
            int fieldCount = this.getFieldCount();
            this.nonMatchTupleBuild = new ArrayTupleBuilder(fieldCount);
            IndexSearchOperatorNodePushable.buildMissingTuple(fieldCount, this.nonMatchTupleBuild, this.nonMatchWriter);
        } else {
            this.nonMatchTupleBuild = null;
        }
        if (this.appendIndexFilter) {
            int numIndexFilterFields = this.index.getNumOfFilterFields();
            this.nonFilterTupleBuild = new ArrayTupleBuilder(numIndexFilterFields);
            IndexSearchOperatorNodePushable.buildMissingTuple(numIndexFilterFields, this.nonFilterTupleBuild, this.nonMatchWriter);
        }
        try {
            this.searchPred = this.createSearchPredicate();
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
            ISearchOperationCallback searchCallback = this.searchCallbackFactory.createSearchOperationCallback(this.indexHelper.getResource().getId(), this.ctx, null);
            this.indexAccessor = this.index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, searchCallback);
            this.cursor = this.createCursor();
            if (this.retainInput) {
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    protected void writeSearchResults(int tupleIndex) throws Exception {
        boolean matched = false;
        while (this.cursor.hasNext()) {
            matched = true;
            this.tb.reset();
            this.cursor.next();
            if (this.retainInput) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
                for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                    this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                    this.tb.addFieldEndOffset();
                }
            }
            ITupleReference tuple = this.cursor.getTuple();
            this.writeTupleToOutput(tuple);
            if (this.appendIndexFilter) {
                this.writeFilterTupleToOutput(this.cursor.getFilterMinTuple());
                this.writeFilterTupleToOutput(this.cursor.getFilterMaxTuple());
            }
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
        }
        if (!matched && this.retainInput && this.retainMissing) {
            FrameUtils.appendConcatToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)tupleIndex, (int[])this.nonMatchTupleBuild.getFieldEndOffsets(), (byte[])this.nonMatchTupleBuild.getByteArray(), (int)0, (int)this.nonMatchTupleBuild.getSize());
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        try {
            for (int i = 0; i < tupleCount; ++i) {
                this.resetSearchPredicate(i);
                this.cursor.reset();
                this.indexAccessor.search(this.cursor, this.searchPred);
                this.writeSearchResults(i);
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }

    public void close() throws HyracksDataException {
        HyracksDataException closeException = null;
        if (this.index != null) {
            if (!this.failed) {
                try {
                    if (this.appender.getTupleCount() > 0) {
                        this.appender.write(this.writer, true);
                    }
                }
                catch (Throwable th) {
                    this.writer.fail();
                    closeException = new HyracksDataException(th);
                }
            }
            try {
                this.cursor.close();
            }
            catch (Throwable th) {
                if (closeException == null) {
                    closeException = new HyracksDataException(th);
                }
                closeException.addSuppressed(th);
            }
            try {
                this.indexHelper.close();
            }
            catch (Throwable th) {
                if (closeException == null) {
                    closeException = new HyracksDataException(th);
                }
                closeException.addSuppressed(th);
            }
        }
        try {
            this.writer.close();
        }
        catch (Throwable th) {
            if (closeException == null) {
                closeException = new HyracksDataException(th);
            }
            closeException.addSuppressed(th);
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        this.writer.fail();
    }

    private void writeTupleToOutput(ITupleReference tuple) throws IOException {
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            this.dos.write(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            this.tb.addFieldEndOffset();
        }
    }

    private void writeFilterTupleToOutput(ITupleReference tuple) throws IOException {
        if (tuple != null) {
            this.writeTupleToOutput(tuple);
        } else {
            int[] offsets = this.nonFilterTupleBuild.getFieldEndOffsets();
            for (int i = 0; i < offsets.length; ++i) {
                int start = i > 0 ? offsets[i - 1] : 0;
                this.tb.addField(this.nonFilterTupleBuild.getByteArray(), start, offsets[i]);
            }
        }
    }

    private static void buildMissingTuple(int numFields, ArrayTupleBuilder nullTuple, IMissingWriter nonMatchWriter) {
        DataOutput out = nullTuple.getDataOutput();
        for (int i = 0; i < numFields; ++i) {
            try {
                nonMatchWriter.writeMissing(out);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            nullTuple.addFieldEndOffset();
        }
    }
}

