/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IResourceLifecycleManager;

public class IndexLifecycleManager
implements IResourceLifecycleManager<IIndex>,
ILifeCycleComponent {
    private static final long DEFAULT_MEMORY_BUDGET = 0x6400000L;
    private final Map<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
    private final long memoryBudget;
    private long memoryUsed;

    public IndexLifecycleManager() {
        this(0x6400000L);
    }

    public IndexLifecycleManager(long memoryBudget) {
        this.memoryBudget = memoryBudget;
        this.memoryUsed = 0L;
    }

    private boolean evictCandidateIndex() throws HyracksDataException {
        IndexInfo info = Collections.min(this.indexInfos.values());
        if (info.referenceCount != 0 || !info.isOpen) {
            return false;
        }
        info.index.deactivate();
        for (Map.Entry<String, IndexInfo> entry : this.indexInfos.entrySet()) {
            if (entry.getValue() != info) continue;
            this.deallocateMemory(entry.getKey());
            break;
        }
        info.isOpen = false;
        return true;
    }

    public List<IIndex> getOpenResources() {
        ArrayList<IIndex> openIndexes = new ArrayList<IIndex>();
        for (IndexInfo i : this.indexInfos.values()) {
            if (!i.isOpen) continue;
            openIndexes.add(i.index);
        }
        return openIndexes;
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream outputStream) throws IOException {
        if (dumpState) {
            this.dumpState(outputStream);
        }
        for (IndexInfo i : this.indexInfos.values()) {
            if (!i.isOpen) continue;
            i.index.deactivate();
        }
    }

    public void dumpState(OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Memory budget = %d\n", this.memoryBudget));
        sb.append(String.format("Memory used = %d\n", this.memoryUsed));
        String headerFormat = "%-20s %-10s %-20s %-20s %-20s\n";
        String rowFormat = "%-20d %-10b %-20d %-20s %-20s\n";
        sb.append(String.format(headerFormat, "ResourceName", "Open", "Reference Count", "Last Access", "Index Name"));
        for (Map.Entry<String, IndexInfo> entry : this.indexInfos.entrySet()) {
            IndexInfo ii = entry.getValue();
            sb.append(String.format(rowFormat, entry.getKey(), ii.isOpen, ii.referenceCount, ii.lastAccess, ii.index));
        }
        os.write(sb.toString().getBytes());
    }

    public void register(String resourcePath, IIndex index) throws HyracksDataException {
        if (this.indexInfos.containsKey(resourcePath)) {
            throw new HyracksDataException("Index with resource name " + resourcePath + " already exists.");
        }
        this.indexInfos.put(resourcePath, new IndexInfo(index));
    }

    public void open(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        if (info == null) {
            throw new HyracksDataException("Failed to open index with resource name " + resourcePath + " since it does not exist.");
        }
        if (!info.isOpen) {
            this.allocateMemory(resourcePath);
            info.index.activate();
            info.isOpen = true;
        }
        info.touch();
    }

    public void close(String resourcePath) throws HyracksDataException {
        this.indexInfos.get(resourcePath).untouch();
    }

    public IIndex get(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        return info == null ? null : info.index;
    }

    public void unregister(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        if (info == null) {
            throw new HyracksDataException("Index with resource name " + resourcePath + " does not exist.");
        }
        if (info.referenceCount != 0) {
            this.indexInfos.put(resourcePath, info);
            throw new HyracksDataException("Cannot remove index while it is open.");
        }
        if (info.isOpen) {
            info.index.deactivate();
            this.deallocateMemory(resourcePath);
        }
        this.indexInfos.remove(resourcePath);
    }

    public void allocateMemory(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        if (info == null) {
            throw new HyracksDataException("Failed to allocate memory for index with resource ID " + resourcePath + " since it does not exist.");
        }
        if (!info.memoryAllocated) {
            long inMemorySize = info.index.getMemoryAllocationSize();
            while (this.memoryUsed + inMemorySize > this.memoryBudget) {
                if (this.evictCandidateIndex()) continue;
                throw new HyracksDataException("Cannot allocate memory for index since memory budget would be exceeded.");
            }
            this.memoryUsed += inMemorySize;
            info.memoryAllocated = true;
        }
    }

    private void deallocateMemory(String resourcePath) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourcePath);
        if (info == null) {
            throw new HyracksDataException("Failed to deallocate memory for index with resource name " + resourcePath + " since it does not exist.");
        }
        if (info.isOpen && info.memoryAllocated) {
            this.memoryUsed -= info.index.getMemoryAllocationSize();
            info.memoryAllocated = false;
        }
    }

    private class IndexInfo
    implements Comparable<IndexInfo> {
        private final IIndex index;
        private int referenceCount;
        private long lastAccess;
        private boolean isOpen;
        private boolean memoryAllocated;

        public IndexInfo(IIndex index) {
            this.index = index;
            this.lastAccess = -1L;
            this.referenceCount = 0;
            this.isOpen = false;
            this.memoryAllocated = false;
        }

        public void touch() {
            this.lastAccess = System.currentTimeMillis();
            ++this.referenceCount;
        }

        public void untouch() {
            this.lastAccess = System.currentTimeMillis();
            --this.referenceCount;
        }

        @Override
        public int compareTo(IndexInfo i) {
            if (this.isOpen && !i.isOpen) {
                return -1;
            }
            if (!this.isOpen && i.isOpen) {
                return 1;
            }
            if (this.referenceCount < i.referenceCount) {
                return -1;
            }
            if (this.referenceCount > i.referenceCount) {
                return 1;
            }
            if (this.lastAccess < i.lastAccess) {
                return -1;
            }
            if (this.lastAccess > i.lastAccess) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "{index: " + this.index + ", isOpen: " + this.isOpen + ", refCount: " + this.referenceCount + ", lastAccess: " + this.lastAccess + "}";
        }
    }
}

