/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IResourceLifecycleManager;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.LocalResource;

public class IndexDataflowHelper
implements IIndexDataflowHelper {
    private final INCServiceContext ctx;
    private final IResourceLifecycleManager<IIndex> lcManager;
    private final ILocalResourceRepository localResourceRepository;
    private final FileReference resourceRef;
    private IIndex index;

    public IndexDataflowHelper(INCServiceContext ctx, IStorageManager storageMgr, FileReference resourceRef) throws HyracksDataException {
        this.ctx = ctx;
        this.lcManager = storageMgr.getLifecycleManager(ctx);
        this.localResourceRepository = storageMgr.getLocalResourceRepository(ctx);
        this.resourceRef = resourceRef;
    }

    @Override
    public IIndex getIndexInstance() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.index = (IIndex)this.lcManager.get(this.resourceRef.getRelativePath());
            if (this.index == null) {
                LocalResource lr = this.readIndex();
                this.lcManager.register(lr.getPath(), (Object)this.index);
            }
            this.lcManager.open(this.resourceRef.getRelativePath());
        }
    }

    private LocalResource readIndex() throws HyracksDataException {
        LocalResource lr = this.getResource();
        if (lr == null) {
            throw new HyracksDataException("Index resource couldn't be found. Has it been created yet? Was it deleted?");
        }
        IResource resource = lr.getResource();
        this.index = resource.createInstance(this.ctx);
        return lr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.lcManager.close(this.resourceRef.getRelativePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.index = (IIndex)this.lcManager.get(this.resourceRef.getRelativePath());
            if (this.index != null) {
                this.lcManager.unregister(this.resourceRef.getRelativePath());
            } else {
                this.readIndex();
            }
            if (this.getResourceId() != -1L) {
                this.localResourceRepository.delete(this.resourceRef.getRelativePath());
            }
            this.index.destroy();
        }
    }

    private long getResourceId() throws HyracksDataException {
        LocalResource lr = this.localResourceRepository.get(this.resourceRef.getRelativePath());
        return lr == null ? -1L : lr.getId();
    }

    @Override
    public LocalResource getResource() throws HyracksDataException {
        return this.localResourceRepository.get(this.resourceRef.getRelativePath());
    }
}

