/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.build;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.IIndexBuilder;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.IResourceLifecycleManager;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;

public class IndexBuilder
implements IIndexBuilder {
    private static final Logger LOGGER = Logger.getLogger(IndexBuilder.class.getName());
    protected final INCServiceContext ctx;
    protected final IStorageManager storageManager;
    protected final FileReference resourceRef;
    protected final IResourceFactory localResourceFactory;
    protected final boolean durable;
    private final IResourceIdFactory resourceIdFactory;

    public IndexBuilder(INCServiceContext ctx, IStorageManager storageManager, IResourceIdFactory resourceIdFactory, FileReference resourceRef, IResourceFactory localResourceFactory, boolean durable) throws HyracksDataException {
        this.ctx = ctx;
        this.storageManager = storageManager;
        this.resourceIdFactory = resourceIdFactory;
        this.localResourceFactory = localResourceFactory;
        this.durable = durable;
        this.resourceRef = resourceRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build() throws HyracksDataException {
        IResourceLifecycleManager lcManager;
        IResourceLifecycleManager iResourceLifecycleManager = lcManager = this.storageManager.getLifecycleManager(this.ctx);
        synchronized (iResourceLifecycleManager) {
            long resourceId;
            ILocalResourceRepository localResourceRepository = this.storageManager.getLocalResourceRepository(this.ctx);
            LocalResource lr = localResourceRepository.get(this.resourceRef.getRelativePath());
            long l = resourceId = lr == null ? -1L : lr.getId();
            if (resourceId != -1L) {
                localResourceRepository.delete(this.resourceRef.getRelativePath());
            }
            resourceId = this.resourceIdFactory.createId();
            IResource resource = this.localResourceFactory.createResource(this.resourceRef);
            lr = new LocalResource(resourceId, 6, this.durable, resource);
            IIndex index = (IIndex)lcManager.get(this.resourceRef.getRelativePath());
            if (index != null) {
                LOGGER.log(Level.WARNING, "Removing existing index on index create for the index: " + this.resourceRef.getRelativePath());
                lcManager.unregister(this.resourceRef.getRelativePath());
                index.destroy();
            } else {
                if (this.resourceRef.getFile().exists()) {
                    LOGGER.log(Level.WARNING, "Deleting " + this.resourceRef.getRelativePath() + " on index create. The index is not registered but the file exists in the filesystem");
                    IoUtil.delete((FileReference)this.resourceRef);
                }
                index = resource.createInstance(this.ctx);
            }
            index.create();
            try {
                localResourceRepository.insert(lr);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            lcManager.register(this.resourceRef.getRelativePath(), (Object)index);
        }
    }
}

