/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.ipc;

import java.net.InetSocketAddress;
import java.util.logging.Logger;
import org.apache.hyracks.control.common.ipc.IControllerRemoteProxyIPCEventListener;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.hyracks.ipc.impl.IPCSystem;

public abstract class ControllerRemoteProxy {
    protected final IPCSystem ipc;
    protected final InetSocketAddress inetSocketAddress;
    private final IControllerRemoteProxyIPCEventListener eventListener;
    private IIPCHandle ipcHandle;

    protected ControllerRemoteProxy(IPCSystem ipc, InetSocketAddress inetSocketAddress) {
        this(ipc, inetSocketAddress, null);
    }

    protected ControllerRemoteProxy(IPCSystem ipc, InetSocketAddress inetSocketAddress, IControllerRemoteProxyIPCEventListener eventListener) {
        this.ipc = ipc;
        this.inetSocketAddress = inetSocketAddress;
        this.eventListener = eventListener == null ? new IControllerRemoteProxyIPCEventListener(){} : eventListener;
    }

    protected IIPCHandle ensureIpcHandle() throws IPCException {
        boolean first;
        boolean bl = first = this.ipcHandle == null;
        if (first || !this.ipcHandle.isConnected()) {
            if (!first) {
                this.getLogger().warning("ipcHandle " + this.ipcHandle + " disconnected; retrying connection");
                this.eventListener.ipcHandleDisconnected(this.ipcHandle);
            }
            this.ipcHandle = this.ipc.getHandle(this.inetSocketAddress, this.getRetries(first));
            if (this.ipcHandle.isConnected()) {
                if (first) {
                    this.eventListener.ipcHandleConnected(this.ipcHandle);
                } else {
                    this.getLogger().warning("ipcHandle " + this.ipcHandle + " restored");
                    this.eventListener.ipcHandleRestored(this.ipcHandle);
                }
            }
        }
        return this.ipcHandle;
    }

    protected abstract int getRetries(boolean var1);

    protected abstract Logger getLogger();
}

