/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.ControllerConfig;

public class NCConfig
extends ControllerConfig {
    private static final long serialVersionUID = 3L;
    public static final int NCSERVICE_PORT_DISABLED = -1;
    private List<String> appArgs = new ArrayList<String>();
    private final IApplicationConfig appConfig;
    private final String nodeId;

    public NCConfig(String nodeId) {
        this(nodeId, new ConfigManager(null));
    }

    public NCConfig(String nodeId, ConfigManager configManager) {
        super(configManager);
        this.appConfig = nodeId == null ? configManager.getAppConfig() : configManager.getNodeEffectiveConfig(nodeId);
        configManager.register(Option.class);
        this.setNodeId(nodeId);
        this.nodeId = nodeId;
        configManager.registerArgsListener(this.appArgs::addAll);
    }

    public List<String> getAppArgs() {
        return this.appArgs;
    }

    public String[] getAppArgsArray() {
        return this.appArgs.toArray(new String[this.appArgs.size()]);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public IApplicationConfig getAppConfig() {
        return this.appConfig;
    }

    public String getPublicAddress() {
        return this.appConfig.getString((IOption)Option.PUBLIC_ADDRESS);
    }

    public void setPublicAddress(String publicAddress) {
        this.configManager.set(this.nodeId, Option.PUBLIC_ADDRESS, publicAddress);
    }

    public String getNCServiceAddress() {
        return this.appConfig.getString((IOption)Option.NCSERVICE_ADDRESS);
    }

    public void setNCServiceAddress(String ncserviceAddress) {
        this.configManager.set(this.nodeId, Option.NCSERVICE_ADDRESS, ncserviceAddress);
    }

    public int getNCServicePort() {
        return this.appConfig.getInt((IOption)Option.NCSERVICE_PORT);
    }

    public void setNCServicePort(int ncservicePort) {
        this.configManager.set(this.nodeId, Option.NCSERVICE_PORT, ncservicePort);
    }

    public String getClusterAddress() {
        return this.appConfig.getString((IOption)Option.CLUSTER_ADDRESS);
    }

    public void setClusterAddress(String clusterAddress) {
        this.configManager.set(this.nodeId, Option.CLUSTER_ADDRESS, clusterAddress);
    }

    public int getClusterPort() {
        return this.appConfig.getInt((IOption)Option.CLUSTER_PORT);
    }

    public void setClusterPort(int clusterPort) {
        this.configManager.set(this.nodeId, Option.CLUSTER_PORT, clusterPort);
    }

    public String getClusterListenAddress() {
        return this.appConfig.getString((IOption)Option.CLUSTER_LISTEN_ADDRESS);
    }

    public void setClusterListenAddress(String clusterListenAddress) {
        this.configManager.set(this.nodeId, Option.CLUSTER_LISTEN_ADDRESS, clusterListenAddress);
    }

    public int getClusterListenPort() {
        return this.appConfig.getInt((IOption)Option.CLUSTER_LISTEN_PORT);
    }

    public void setClusterListenPort(int clusterListenPort) {
        this.configManager.set(this.nodeId, Option.CLUSTER_LISTEN_PORT, clusterListenPort);
    }

    public String getClusterPublicAddress() {
        return this.appConfig.getString((IOption)Option.CLUSTER_PUBLIC_ADDRESS);
    }

    public void setClusterPublicAddress(String clusterPublicAddress) {
        this.configManager.set(this.nodeId, Option.CLUSTER_PUBLIC_ADDRESS, clusterPublicAddress);
    }

    public int getClusterPublicPort() {
        return this.appConfig.getInt((IOption)Option.CLUSTER_PUBLIC_PORT);
    }

    public void setClusterPublicPort(int clusterPublicPort) {
        this.configManager.set(this.nodeId, Option.CLUSTER_PUBLIC_PORT, clusterPublicPort);
    }

    public String getNodeId() {
        return this.appConfig.getString((IOption)Option.NODE_ID);
    }

    public void setNodeId(String nodeId) {
        this.configManager.set(nodeId, Option.NODE_ID, nodeId);
    }

    public String getDataListenAddress() {
        return this.appConfig.getString((IOption)Option.DATA_LISTEN_ADDRESS);
    }

    public void setDataListenAddress(String dataListenAddress) {
        this.configManager.set(this.nodeId, Option.DATA_LISTEN_ADDRESS, dataListenAddress);
    }

    public int getDataListenPort() {
        return this.appConfig.getInt((IOption)Option.DATA_LISTEN_PORT);
    }

    public void setDataListenPort(int dataListenPort) {
        this.configManager.set(this.nodeId, Option.DATA_LISTEN_PORT, dataListenPort);
    }

    public String getDataPublicAddress() {
        return this.appConfig.getString((IOption)Option.DATA_PUBLIC_ADDRESS);
    }

    public void setDataPublicAddress(String dataPublicAddress) {
        this.configManager.set(this.nodeId, Option.DATA_PUBLIC_ADDRESS, dataPublicAddress);
    }

    public int getDataPublicPort() {
        return this.appConfig.getInt((IOption)Option.DATA_PUBLIC_PORT);
    }

    public void setDataPublicPort(int dataPublicPort) {
        this.configManager.set(this.nodeId, Option.DATA_PUBLIC_PORT, dataPublicPort);
    }

    public String getResultListenAddress() {
        return this.appConfig.getString((IOption)Option.RESULT_LISTEN_ADDRESS);
    }

    public void setResultListenAddress(String resultListenAddress) {
        this.configManager.set(this.nodeId, Option.RESULT_LISTEN_ADDRESS, resultListenAddress);
    }

    public int getResultListenPort() {
        return this.appConfig.getInt((IOption)Option.RESULT_LISTEN_PORT);
    }

    public void setResultListenPort(int resultListenPort) {
        this.configManager.set(this.nodeId, Option.RESULT_LISTEN_PORT, resultListenPort);
    }

    public String getResultPublicAddress() {
        return this.appConfig.getString((IOption)Option.RESULT_PUBLIC_ADDRESS);
    }

    public void setResultPublicAddress(String resultPublicAddress) {
        this.configManager.set(this.nodeId, Option.RESULT_PUBLIC_ADDRESS, resultPublicAddress);
    }

    public int getResultPublicPort() {
        return this.appConfig.getInt((IOption)Option.RESULT_PUBLIC_PORT);
    }

    public void setResultPublicPort(int resultPublicPort) {
        this.configManager.set(this.nodeId, Option.RESULT_PUBLIC_PORT, resultPublicPort);
    }

    public String getMessagingListenAddress() {
        return this.appConfig.getString((IOption)Option.MESSAGING_LISTEN_ADDRESS);
    }

    public void setMessagingListenAddress(String messagingListenAddress) {
        this.configManager.set(this.nodeId, Option.MESSAGING_LISTEN_ADDRESS, messagingListenAddress);
    }

    public int getMessagingListenPort() {
        return this.appConfig.getInt((IOption)Option.MESSAGING_LISTEN_PORT);
    }

    public void setMessagingListenPort(int messagingListenPort) {
        this.configManager.set(this.nodeId, Option.MESSAGING_LISTEN_PORT, messagingListenPort);
    }

    public String getMessagingPublicAddress() {
        return this.appConfig.getString((IOption)Option.MESSAGING_PUBLIC_ADDRESS);
    }

    public void setMessagingPublicAddress(String messagingPublicAddress) {
        this.configManager.set(this.nodeId, Option.MESSAGING_PUBLIC_ADDRESS, messagingPublicAddress);
    }

    public int getMessagingPublicPort() {
        return this.appConfig.getInt((IOption)Option.MESSAGING_PUBLIC_PORT);
    }

    public void setMessagingPublicPort(int messagingPublicPort) {
        this.configManager.set(this.nodeId, Option.MESSAGING_PUBLIC_PORT, messagingPublicPort);
    }

    public int getClusterConnectRetries() {
        return this.appConfig.getInt((IOption)Option.CLUSTER_CONNECT_RETRIES);
    }

    public void setClusterConnectRetries(int clusterConnectRetries) {
        this.configManager.set(this.nodeId, Option.CLUSTER_CONNECT_RETRIES, clusterConnectRetries);
    }

    public String[] getIODevices() {
        return this.appConfig.getStringArray((IOption)Option.IODEVICES);
    }

    public void setIODevices(String[] iodevices) {
        this.configManager.set(this.nodeId, Option.IODEVICES, iodevices);
    }

    public int getNetThreadCount() {
        return this.appConfig.getInt((IOption)Option.NET_THREAD_COUNT);
    }

    public void setNetThreadCount(int netThreadCount) {
        this.configManager.set(this.nodeId, Option.NET_THREAD_COUNT, netThreadCount);
    }

    public int getNetBufferCount() {
        return this.appConfig.getInt((IOption)Option.NET_BUFFER_COUNT);
    }

    public void setNetBufferCount(int netBufferCount) {
        this.configManager.set(this.nodeId, Option.NET_BUFFER_COUNT, netBufferCount);
    }

    public long getResultTTL() {
        return this.appConfig.getLong((IOption)Option.RESULT_TTL);
    }

    public void setResultTTL(long resultTTL) {
        this.configManager.set(this.nodeId, Option.RESULT_TTL, resultTTL);
    }

    public long getResultSweepThreshold() {
        return this.appConfig.getLong((IOption)Option.RESULT_SWEEP_THRESHOLD);
    }

    public void setResultSweepThreshold(long resultSweepThreshold) {
        this.configManager.set(this.nodeId, Option.RESULT_SWEEP_THRESHOLD, resultSweepThreshold);
    }

    public int getResultManagerMemory() {
        return this.appConfig.getInt((IOption)Option.RESULT_MANAGER_MEMORY);
    }

    public void setResultManagerMemory(int resultManagerMemory) {
        this.configManager.set(this.nodeId, Option.RESULT_MANAGER_MEMORY, resultManagerMemory);
    }

    public String getAppClass() {
        return this.appConfig.getString((IOption)Option.APP_CLASS);
    }

    public void setAppClass(String appClass) {
        this.configManager.set(this.nodeId, Option.APP_CLASS, appClass);
    }

    public int getNCServicePid() {
        return this.appConfig.getInt((IOption)Option.NCSERVICE_PID);
    }

    public void setNCServicePid(int ncservicePid) {
        this.configManager.set(this.nodeId, Option.NCSERVICE_PID, ncservicePid);
    }

    public boolean isVirtualNC() {
        return this.appConfig.getInt((IOption)Option.NCSERVICE_PORT) == -1;
    }

    public void setVirtualNC() {
        this.configManager.set(this.nodeId, Option.NCSERVICE_PORT, -1);
    }

    /*
     * Exception performing whole class analysis.
     */
    public static final class Option
    extends Enum<Option>
    implements IOption {
        public static final /* enum */ Option ADDRESS;
        public static final /* enum */ Option PUBLIC_ADDRESS;
        public static final /* enum */ Option CLUSTER_LISTEN_ADDRESS;
        public static final /* enum */ Option CLUSTER_LISTEN_PORT;
        public static final /* enum */ Option NCSERVICE_ADDRESS;
        public static final /* enum */ Option NCSERVICE_PORT;
        public static final /* enum */ Option CLUSTER_ADDRESS;
        public static final /* enum */ Option CLUSTER_PORT;
        public static final /* enum */ Option CLUSTER_PUBLIC_ADDRESS;
        public static final /* enum */ Option CLUSTER_PUBLIC_PORT;
        public static final /* enum */ Option NODE_ID;
        public static final /* enum */ Option DATA_LISTEN_ADDRESS;
        public static final /* enum */ Option DATA_LISTEN_PORT;
        public static final /* enum */ Option DATA_PUBLIC_ADDRESS;
        public static final /* enum */ Option DATA_PUBLIC_PORT;
        public static final /* enum */ Option RESULT_LISTEN_ADDRESS;
        public static final /* enum */ Option RESULT_LISTEN_PORT;
        public static final /* enum */ Option RESULT_PUBLIC_ADDRESS;
        public static final /* enum */ Option RESULT_PUBLIC_PORT;
        public static final /* enum */ Option MESSAGING_LISTEN_ADDRESS;
        public static final /* enum */ Option MESSAGING_LISTEN_PORT;
        public static final /* enum */ Option MESSAGING_PUBLIC_ADDRESS;
        public static final /* enum */ Option MESSAGING_PUBLIC_PORT;
        public static final /* enum */ Option CLUSTER_CONNECT_RETRIES;
        public static final /* enum */ Option IODEVICES;
        public static final /* enum */ Option NET_THREAD_COUNT;
        public static final /* enum */ Option NET_BUFFER_COUNT;
        public static final /* enum */ Option RESULT_TTL;
        public static final /* enum */ Option RESULT_SWEEP_THRESHOLD;
        public static final /* enum */ Option RESULT_MANAGER_MEMORY;
        public static final /* enum */ Option APP_CLASS;
        public static final /* enum */ Option NCSERVICE_PID;
        public static final /* enum */ Option COMMAND;
        public static final /* enum */ Option JVM_ARGS;
        private final IOptionType parser;
        private final String defaultValueDescription;
        private Object defaultValue;
        private static final /* synthetic */ Option[] $VALUES;

        public static Option[] values() {
            return (Option[])$VALUES.clone();
        }

        public static Option valueOf(String name) {
            return Enum.valueOf(Option.class, name);
        }

        private <T> Option(IOptionType<T> parser, Option defaultOption) {
            super(string, n);
            this.parser = parser;
            this.defaultValue = defaultOption;
            this.defaultValueDescription = null;
        }

        private <T> Option(IOptionType<T> parser, T defaultValue) {
            super(string, n);
            this.parser = parser;
            this.defaultValue = defaultValue;
            this.defaultValueDescription = null;
        }

        private <T> Option(IOptionType<T> parser, Function<IApplicationConfig, T> defaultValue, String defaultValueDescription) {
            super(string, n);
            this.parser = parser;
            this.defaultValue = defaultValue;
            this.defaultValueDescription = defaultValueDescription;
        }

        public Section section() {
            switch (this) {
                case NODE_ID: {
                    return Section.LOCALNC;
                }
            }
            return Section.NC;
        }

        public String description() {
            switch (this) {
                case ADDRESS: {
                    return "Default IP Address to bind listeners on this NC.  All services will bind on this address unless a service-specific listen address is supplied.";
                }
                case CLUSTER_LISTEN_ADDRESS: {
                    return "IP Address to bind cluster listener on this NC";
                }
                case PUBLIC_ADDRESS: {
                    return "Default public address that other processes should use to contact this NC.  All services will advertise this address unless a service-specific public address is supplied.";
                }
                case NCSERVICE_ADDRESS: {
                    return "Address the CC should use to contact the NCService associated with this NC";
                }
                case NCSERVICE_PORT: {
                    return "Port the CC should use to contact the NCService associated with this NC (-1 to not use NCService to start this NC)";
                }
                case CLUSTER_ADDRESS: {
                    return "Cluster Controller address (required unless specified in config file)";
                }
                case CLUSTER_PORT: {
                    return "Cluster Controller port";
                }
                case CLUSTER_LISTEN_PORT: {
                    return "IP port to bind cluster listener";
                }
                case CLUSTER_PUBLIC_ADDRESS: {
                    return "Public IP Address to announce cluster listener";
                }
                case CLUSTER_PUBLIC_PORT: {
                    return "Public IP port to announce cluster listener";
                }
                case NODE_ID: {
                    return "Logical name of node controller unique within the cluster (required unless specified in config file)";
                }
                case DATA_LISTEN_ADDRESS: {
                    return "IP Address to bind data listener";
                }
                case DATA_LISTEN_PORT: {
                    return "IP port to bind data listener";
                }
                case DATA_PUBLIC_ADDRESS: {
                    return "Public IP Address to announce data listener";
                }
                case DATA_PUBLIC_PORT: {
                    return "Public IP port to announce data listener";
                }
                case RESULT_LISTEN_ADDRESS: {
                    return "IP Address to bind dataset result distribution listener";
                }
                case RESULT_LISTEN_PORT: {
                    return "IP port to bind dataset result distribution listener";
                }
                case RESULT_PUBLIC_ADDRESS: {
                    return "Public IP Address to announce dataset result distribution listener";
                }
                case RESULT_PUBLIC_PORT: {
                    return "Public IP port to announce dataset result distribution listener";
                }
                case MESSAGING_LISTEN_ADDRESS: {
                    return "IP Address to bind messaging listener";
                }
                case MESSAGING_LISTEN_PORT: {
                    return "IP port to bind messaging listener";
                }
                case MESSAGING_PUBLIC_ADDRESS: {
                    return "Public IP Address to announce messaging listener";
                }
                case MESSAGING_PUBLIC_PORT: {
                    return "Public IP port to announce messaging listener";
                }
                case CLUSTER_CONNECT_RETRIES: {
                    return "Number of attempts to contact CC before giving up";
                }
                case IODEVICES: {
                    return "Comma separated list of IO Device mount points";
                }
                case NET_THREAD_COUNT: {
                    return "Number of threads to use for Network I/O";
                }
                case NET_BUFFER_COUNT: {
                    return "Number of network buffers per input/output channel";
                }
                case RESULT_TTL: {
                    return "Limits the amount of time results for asynchronous jobs should be retained by the system in milliseconds";
                }
                case RESULT_SWEEP_THRESHOLD: {
                    return "The duration within which an instance of the result cleanup should be invoked in milliseconds";
                }
                case RESULT_MANAGER_MEMORY: {
                    return "Memory usable for result caching at this Node Controller in bytes";
                }
                case APP_CLASS: {
                    return "Application NC Main Class";
                }
                case NCSERVICE_PID: {
                    return "PID of the NCService which launched this NCDriver";
                }
                case COMMAND: {
                    return "Command NCService should invoke to start the NCDriver";
                }
                case JVM_ARGS: {
                    return "JVM args to pass to the NCDriver";
                }
            }
            throw new IllegalStateException("NYI: " + (Object)((Object)this));
        }

        public IOptionType type() {
            return this.parser;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
            return this.defaultValueDescription;
        }

        /*
         * Exception decompiling
         */
        static {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

