/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.config;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.util.StorageUtil;

public class OptionTypes {
    public static final IOptionType<Integer> INTEGER_BYTE_UNIT = new IOptionType<Integer>(){

        public Integer parse(String s) {
            if (s == null) {
                return null;
            }
            long result1 = StorageUtil.getByteValue((String)s);
            if (result1 > Integer.MAX_VALUE || result1 < Integer.MIN_VALUE) {
                throw new IllegalArgumentException("The given value: " + result1 + " is not within the int range.");
            }
            return (int)result1;
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Integer)value).intValue()) + ")";
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Integer)value).intValue());
        }
    };
    public static final IOptionType<Long> LONG_BYTE_UNIT = new IOptionType<Long>(){

        public Long parse(String s) {
            return s == null ? null : Long.valueOf(StorageUtil.getByteValue((String)s));
        }

        public Class<Long> targetType() {
            return Long.class;
        }

        public String serializeToHumanReadable(Object value) {
            return value + " (" + StorageUtil.toHumanReadableSize((long)((Long)value)) + ")";
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Long)value).longValue());
        }
    };
    public static final IOptionType<Integer> INTEGER = new IOptionType<Integer>(){

        public Integer parse(String s) {
            return Integer.parseInt(s);
        }

        public Class<Integer> targetType() {
            return Integer.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Integer)value).intValue());
        }
    };
    public static final IOptionType<Double> DOUBLE = new IOptionType<Double>(){

        public Double parse(String s) {
            return Double.parseDouble(s);
        }

        public Class<Double> targetType() {
            return Double.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Double)value).doubleValue());
        }
    };
    public static final IOptionType<String> STRING = new IOptionType<String>(){

        public String parse(String s) {
            return s;
        }

        public Class<String> targetType() {
            return String.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, (String)value);
        }
    };
    public static final IOptionType<Long> LONG = new IOptionType<Long>(){

        public Long parse(String s) {
            return Long.parseLong(s);
        }

        public Class<Long> targetType() {
            return Long.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Long)value).longValue());
        }
    };
    public static final IOptionType<Boolean> BOOLEAN = new IOptionType<Boolean>(){

        public Boolean parse(String s) {
            return Boolean.parseBoolean(s);
        }

        public Class<Boolean> targetType() {
            return Boolean.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, ((Boolean)value).booleanValue());
        }
    };
    public static final IOptionType<Level> LEVEL = new IOptionType<Level>(){

        public Level parse(String s) {
            return s == null ? null : Level.parse(s);
        }

        public Class<Level> targetType() {
            return Level.class;
        }

        public String serializeToJSON(Object value) {
            return value == null ? null : ((Level)value).getName();
        }

        public String serializeToIni(Object value) {
            return ((Level)value).getName();
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, this.serializeToJSON(value));
        }
    };
    public static final IOptionType<String[]> STRING_ARRAY = new IOptionType<String[]>(){

        public String[] parse(String s) {
            return s == null ? null : s.split("\\s*,\\s*");
        }

        public Class<String[]> targetType() {
            return String[].class;
        }

        public String serializeToIni(Object value) {
            return String.join((CharSequence)",", (String[])value);
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, value == null ? null : StringUtils.join((Object[])((String[])value), (char)','));
        }
    };
    public static final IOptionType<URL> URL = new IOptionType<URL>(){

        public URL parse(String s) {
            try {
                return s == null ? null : new URL(s);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Class<URL> targetType() {
            return URL.class;
        }

        public void serializeJSONField(String fieldName, Object value, ObjectNode node) {
            node.put(fieldName, value == null ? null : String.valueOf(value));
        }
    };

    private OptionTypes() {
    }
}

