/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.FloatSerializerDeserializer;

public class IntegerToFloatTypeConvertComputer
implements ITypeConvertComputer {
    private static final IntegerToFloatTypeConvertComputer INSTANCE = new IntegerToFloatTypeConvertComputer();

    private IntegerToFloatTypeConvertComputer() {
    }

    public static IntegerToFloatTypeConvertComputer getInstance() {
        return INSTANCE;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        float val;
        switch (length) {
            case 1: {
                val = BytePointable.getByte((byte[])data, (int)start);
                break;
            }
            case 2: {
                val = ShortPointable.getShort((byte[])data, (int)start);
                break;
            }
            case 4: {
                val = IntegerPointable.getInteger((byte[])data, (int)start);
                break;
            }
            case 8: {
                val = LongPointable.getLong((byte[])data, (int)start);
                break;
            }
            default: {
                throw new RuntimeDataException(19, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
            }
        }
        out.writeByte(ATypeTag.FLOAT.serialize());
        FloatSerializerDeserializer.write((float)val, (DataOutput)out);
    }

    @Override
    public IAObject convertType(IAObject sourceObject) throws HyracksDataException {
        float val;
        switch (sourceObject.getType().getTypeTag()) {
            case TINYINT: {
                val = ((AInt8)sourceObject).getByteValue();
                break;
            }
            case SMALLINT: {
                val = ((AInt16)sourceObject).getShortValue();
                break;
            }
            case INTEGER: {
                val = ((AInt32)sourceObject).getIntegerValue();
                break;
            }
            case BIGINT: {
                val = ((AInt64)sourceObject).getLongValue();
                break;
            }
            default: {
                throw new RuntimeDataException(19, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
            }
        }
        return new AFloat(val);
    }
}

