/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToInt8TypeConvertComputer
implements ITypeConvertComputer {
    private static final DoubleToInt8TypeConvertComputer INSTANCE_STRICT = new DoubleToInt8TypeConvertComputer(true);
    private static final DoubleToInt8TypeConvertComputer INSTANCE_LAX = new DoubleToInt8TypeConvertComputer(false);
    private final boolean strict;

    private DoubleToInt8TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static DoubleToInt8TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        byte targetValue = this.convert(sourceValue);
        out.writeByte(ATypeTag.TINYINT.serialize());
        out.writeByte(targetValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject) throws HyracksDataException {
        double sourceValue = ((ADouble)sourceObject).getDoubleValue();
        byte targetValue = this.convert(sourceValue);
        return new AInt8(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte convert(double sourceValue) throws HyracksDataException {
        if (Double.isNaN(sourceValue)) {
            if (!this.strict) return 0;
            this.raiseBoundaryCheckException(sourceValue);
        }
        if (sourceValue > 127.0) {
            if (!this.strict) return 127;
            this.raiseBoundaryCheckException(sourceValue);
            return (byte)Math.floor(sourceValue);
        } else {
            if (!(sourceValue < -128.0)) return (byte)Math.floor(sourceValue);
            if (!this.strict) return -128;
            this.raiseBoundaryCheckException(sourceValue);
        }
        return (byte)Math.floor(sourceValue);
    }

    private void raiseBoundaryCheckException(double sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(21, new Serializable[]{Double.valueOf(sourceValue), ATypeTag.TINYINT, Byte.valueOf((byte)127), Byte.valueOf((byte)-128)});
    }
}

