/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;

public class TypeComputeUtils {
    private static final byte CERTAIN = 1;
    private static final byte NULLABLE = 2;
    private static final byte MISSABLE = 4;
    private static final byte MISSING = 8;
    private static final byte NULL = 16;

    private TypeComputeUtils() {
    }

    public static IAType resolveResultType(ILogicalExpression expr, IVariableTypeEnvironment env, ArgTypeChecker checker, ResultTypeGenerator resultTypeGenerator, boolean propagateNullAndMissing) throws AlgebricksException {
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
        IAType[] inputTypes = new IAType[fce.getArguments().size()];
        int index = 0;
        for (Mutable argRef : fce.getArguments()) {
            ILogicalExpression arg = (ILogicalExpression)argRef.getValue();
            inputTypes[index++] = (IAType)env.getType(arg);
        }
        IAType[] knownInputTypes = TypeComputeUtils.getActualType(inputTypes);
        boolean[] unknownable = TypeComputeUtils.isUnknownableType(inputTypes);
        for (int argIndex = 0; argIndex < knownInputTypes.length; ++argIndex) {
            ATypeTag argTypeTag = knownInputTypes[argIndex].getTypeTag();
            if (unknownable[argIndex] || argTypeTag == ATypeTag.ANY || argTypeTag == ATypeTag.NULL || argTypeTag == ATypeTag.MISSING) continue;
            checker.checkArgTypes(argIndex, knownInputTypes[argIndex]);
        }
        byte category = TypeComputeUtils.resolveCateogry(inputTypes);
        if (propagateNullAndMissing) {
            if (category == 8) {
                return BuiltinType.AMISSING;
            }
            if (category == 16) {
                return BuiltinType.ANULL;
            }
            return TypeComputeUtils.getResultType(resultTypeGenerator.getResultType(expr, knownInputTypes), category);
        }
        return resultTypeGenerator.getResultType(expr, knownInputTypes);
    }

    private static byte resolveCateogry(IAType ... inputTypes) {
        byte category = 1;
        boolean meetNull = false;
        block6: for (IAType inputType : inputTypes) {
            switch (inputType.getTypeTag()) {
                case UNION: {
                    AUnionType unionType = (AUnionType)inputType;
                    if (unionType.isNullableType()) {
                        category = (byte)(category | 2);
                    }
                    if (!unionType.isMissableType()) continue block6;
                    category = (byte)(category | 4);
                    continue block6;
                }
                case MISSING: {
                    return 8;
                }
                case NULL: {
                    meetNull = true;
                    continue block6;
                }
                case ANY: {
                    category = (byte)(category | 2);
                    category = (byte)(category | 4);
                    continue block6;
                }
            }
        }
        if (meetNull) {
            return 16;
        }
        return category;
    }

    private static IAType getResultType(IAType type, byte category) {
        if (type.getTypeTag() == ATypeTag.ANY) {
            return type;
        }
        if (category == 1) {
            return type;
        }
        IAType resultType = type;
        if ((category & 2) != 0 || (category & 0x10) != 0) {
            resultType = AUnionType.createUnknownableType(resultType);
        }
        if ((category & 4) != 0 || (category & 8) != 0) {
            resultType = AUnionType.createMissableType(resultType);
        }
        return resultType;
    }

    private static IAType[] getActualType(IAType ... inputTypes) {
        IAType[] actualTypes = new IAType[inputTypes.length];
        int index = 0;
        for (IAType inputType : inputTypes) {
            actualTypes[index++] = TypeComputeUtils.getActualType(inputType);
        }
        return actualTypes;
    }

    private static boolean[] isUnknownableType(IAType ... inputTypes) {
        boolean[] unknownable = new boolean[inputTypes.length];
        for (int index = 0; index < unknownable.length; ++index) {
            IAType type = inputTypes[index];
            unknownable[index] = false;
            if (type.getTypeTag() != ATypeTag.UNION) continue;
            AUnionType unionType = (AUnionType)type;
            unknownable[index] = unionType.isUnknownableType();
        }
        return unknownable;
    }

    public static IAType getActualType(IAType inputType) {
        return inputType.getTypeTag() == ATypeTag.UNION ? ((AUnionType)inputType).getActualType() : inputType;
    }

    public static ARecordType extractRecordType(IAType t) {
        switch (t.getTypeTag()) {
            case OBJECT: {
                return (ARecordType)t;
            }
            case UNION: {
                IAType innerType = ((AUnionType)t).getActualType();
                if (innerType.getTypeTag() == ATypeTag.OBJECT) {
                    return (ARecordType)innerType;
                }
                return null;
            }
            case ANY: {
                return RecordUtil.FULLY_OPEN_RECORD_TYPE;
            }
        }
        return null;
    }

    public static AOrderedListType extractOrderedListType(IAType t) {
        IAType innerType;
        if (t.getTypeTag() == ATypeTag.ARRAY) {
            return (AOrderedListType)t;
        }
        if (t.getTypeTag() == ATypeTag.UNION && (innerType = ((AUnionType)t).getActualType()).getTypeTag() == ATypeTag.ARRAY) {
            return (AOrderedListType)innerType;
        }
        return null;
    }

    public static AUnorderedListType extractUnorderedListType(IAType t) {
        AUnionType unionType;
        IAType innerType;
        if (t.getTypeTag() == ATypeTag.MULTISET) {
            return (AUnorderedListType)t;
        }
        if (t.getTypeTag() == ATypeTag.UNION && (innerType = (unionType = (AUnionType)t).getActualType()).getTypeTag() == ATypeTag.MULTISET) {
            return (AUnorderedListType)innerType;
        }
        return null;
    }

    @FunctionalInterface
    public static interface ResultTypeGenerator {
        public IAType getResultType(ILogicalExpression var1, IAType ... var2) throws AlgebricksException;
    }

    @FunctionalInterface
    public static interface ArgTypeChecker {
        public void checkArgTypes(int var1, IAType var2) throws AlgebricksException;
    }
}

