/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public abstract class ListConstructorTypeComputer
implements IResultTypeComputer {
    protected ListConstructorTypeComputer() {
    }

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
        IAType reqType = TypeCastUtils.getRequiredType(f);
        if (reqType != null) {
            return reqType;
        }
        return this.computeTypeFromItems(env, f);
    }

    private IAType computeTypeFromItems(IVariableTypeEnvironment env, AbstractFunctionCallExpression f) throws AlgebricksException {
        IAType currentType = null;
        boolean any = false;
        for (int k = 0; k < f.getArguments().size(); ++k) {
            IAType type = (IAType)env.getType((ILogicalExpression)((Mutable)f.getArguments().get(k)).getValue());
            if (type.getTypeTag() == ATypeTag.UNION || currentType != null && !currentType.equals(type)) {
                any = true;
                break;
            }
            currentType = type;
        }
        if (any || currentType == null) {
            return this.getListType(BuiltinType.ANY);
        }
        return this.getListType(currentType);
    }

    protected abstract IAType getListType(IAType var1);
}

