/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.valueproviders;

import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.impls.DoublePrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.impls.FloatPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.impls.IntegerPrimitiveValueProviderFactory;

public class PrimitiveValueProviderFactory
implements IPrimitiveValueProviderFactory {
    private static final long serialVersionUID = 1L;
    public static final PrimitiveValueProviderFactory INSTANCE = new PrimitiveValueProviderFactory();

    private PrimitiveValueProviderFactory() {
    }

    public IPrimitiveValueProvider createPrimitiveValueProvider() {
        return new IPrimitiveValueProvider(){
            final IPrimitiveValueProvider intProvider = IntegerPrimitiveValueProviderFactory.INSTANCE.createPrimitiveValueProvider();
            final IPrimitiveValueProvider floatProvider = FloatPrimitiveValueProviderFactory.INSTANCE.createPrimitiveValueProvider();
            final IPrimitiveValueProvider doubleProvider = DoublePrimitiveValueProviderFactory.INSTANCE.createPrimitiveValueProvider();

            public double getValue(byte[] bytes, int offset) {
                ATypeTag tag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
                switch (tag) {
                    case INTEGER: {
                        return this.intProvider.getValue(bytes, offset + 1);
                    }
                    case FLOAT: {
                        return this.floatProvider.getValue(bytes, offset + 1);
                    }
                    case DOUBLE: {
                        return this.doubleProvider.getValue(bytes, offset + 1);
                    }
                }
                throw new NotImplementedException("Value provider for type " + tag + " is not implemented");
            }
        };
    }
}

