/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class AUnorderedListSerializerDeserializer
implements ISerializerDeserializer<AUnorderedList> {
    private static final long serialVersionUID = 1L;
    public static final AUnorderedListSerializerDeserializer SCHEMALESS_INSTANCE = new AUnorderedListSerializerDeserializer();
    private final IAType itemType;
    private final AUnorderedListType unorderedlistType;
    private final ISerializerDeserializer deserializer;
    private final ISerializerDeserializer serializer;

    private AUnorderedListSerializerDeserializer() {
        this(new AUnorderedListType(BuiltinType.ANY, "unorderedlist"));
    }

    public AUnorderedListSerializerDeserializer(AUnorderedListType unorderedlistType) {
        this.unorderedlistType = unorderedlistType;
        this.itemType = unorderedlistType.getItemType();
        this.serializer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(this.itemType);
        this.deserializer = this.itemType.getTypeTag() == ATypeTag.ANY ? SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(this.itemType) : SerializerDeserializerProvider.INSTANCE.getNonTaggedSerializerDeserializer(this.itemType);
    }

    public AUnorderedList deserialize(DataInput in) throws HyracksDataException {
        try {
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(in.readByte());
            IAType currentItemType = this.itemType;
            ISerializerDeserializer currentDeserializer = this.deserializer;
            if (this.itemType.getTypeTag() == ATypeTag.ANY && typeTag != ATypeTag.ANY) {
                currentItemType = TypeTagUtil.getBuiltinTypeByTag(typeTag);
                currentDeserializer = SerializerDeserializerProvider.INSTANCE.getNonTaggedSerializerDeserializer(currentItemType);
            }
            in.readInt();
            int numberOfitems = in.readInt();
            ArrayList<IAObject> items = new ArrayList<IAObject>();
            if (numberOfitems > 0) {
                int i;
                if (!NonTaggedFormatUtil.isFixedSizedCollection(currentItemType)) {
                    for (i = 0; i < numberOfitems; ++i) {
                        in.readInt();
                    }
                }
                for (i = 0; i < numberOfitems; ++i) {
                    items.add((IAObject)currentDeserializer.deserialize(in));
                }
            }
            AUnorderedListType type = new AUnorderedListType(currentItemType, "unorderedlist");
            return new AUnorderedList(type, items);
        }
        catch (IOException | AsterixException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void serialize(AUnorderedList instance, DataOutput out) throws HyracksDataException {
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        listBuilder.reset(this.unorderedlistType);
        IACursor cursor = instance.getCursor();
        while (cursor.next()) {
            itemValue.reset();
            this.serializer.serialize((Object)cursor.get(), itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        listBuilder.write(out, false);
    }

    public static final int getUnorderedListLength(byte[] serOrderedList, int offset) {
        return AInt32SerializerDeserializer.getInt(serOrderedList, offset + 1);
    }

    public static int getNumberOfItems(byte[] serOrderedList, int offset) {
        if (serOrderedList[offset] == ATypeTag.MULTISET.serialize()) {
            return AInt32SerializerDeserializer.getInt(serOrderedList, offset + 6);
        }
        return -1;
    }

    public static int getItemOffset(byte[] serOrderedList, int offset, int itemIndex) throws HyracksDataException {
        if (serOrderedList[offset] == ATypeTag.MULTISET.serialize()) {
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serOrderedList[offset + 1]);
            if (NonTaggedFormatUtil.isFixedSizedCollection(typeTag)) {
                int length = NonTaggedFormatUtil.getFieldValueLength(serOrderedList, offset + 1, typeTag, true);
                return offset + 10 + length * itemIndex;
            }
            return offset + AInt32SerializerDeserializer.getInt(serOrderedList, offset + 10 + 4 * itemIndex);
        }
        return -1;
    }
}

