/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AObjectSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class ARecordSerializerDeserializer
implements ISerializerDeserializer<ARecord> {
    private static final long serialVersionUID = 1L;
    public static final ARecordSerializerDeserializer SCHEMALESS_INSTANCE = new ARecordSerializerDeserializer();
    private static final IAObject[] NO_FIELDS = new IAObject[0];
    private final ARecordType recordType;
    private final int numberOfSchemaFields;
    private final ISerializerDeserializer[] serializers;
    private final ISerializerDeserializer[] deserializers;

    private ARecordSerializerDeserializer() {
        this(null);
    }

    public ARecordSerializerDeserializer(ARecordType recordType) {
        if (recordType != null) {
            this.recordType = recordType;
            this.numberOfSchemaFields = recordType.getFieldNames().length;
            this.serializers = new ISerializerDeserializer[this.numberOfSchemaFields];
            this.deserializers = new ISerializerDeserializer[this.numberOfSchemaFields];
            for (int i = 0; i < this.numberOfSchemaFields; ++i) {
                IAType t = recordType.getFieldTypes()[i];
                IAType t2 = t.getTypeTag() == ATypeTag.UNION ? ((AUnionType)t).getActualType() : t;
                this.serializers[i] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(t2);
                this.deserializers[i] = SerializerDeserializerProvider.INSTANCE.getNonTaggedSerializerDeserializer(t2);
            }
        } else {
            this.recordType = null;
            this.numberOfSchemaFields = 0;
            this.serializers = null;
            this.deserializers = null;
        }
    }

    public ARecord deserialize(DataInput in) throws HyracksDataException {
        try {
            boolean isExpanded = this.isExpandedRecord(in);
            IAObject[] schemaFields = this.getValuesForSchemaFields(in);
            if (isExpanded) {
                int i;
                int numberOfOpenFields = in.readInt();
                String[] fieldNames = new String[numberOfOpenFields];
                IAType[] fieldTypes = new IAType[numberOfOpenFields];
                IAObject[] openFields = new IAObject[numberOfOpenFields];
                for (i = 0; i < numberOfOpenFields; ++i) {
                    in.readInt();
                    in.readInt();
                }
                for (i = 0; i < numberOfOpenFields; ++i) {
                    fieldNames[i] = AStringSerializerDeserializer.INSTANCE.deserialize(in).getStringValue();
                    openFields[i] = AObjectSerializerDeserializer.INSTANCE.deserialize(in);
                    fieldTypes[i] = openFields[i].getType();
                }
                ARecordType openPartRecType = new ARecordType(null, fieldNames, fieldTypes, true);
                if (this.numberOfSchemaFields > 0) {
                    ARecordType mergedRecordType = this.mergeRecordTypes(this.recordType, openPartRecType);
                    IAObject[] mergedFields = this.mergeFields(schemaFields, openFields);
                    return new ARecord(mergedRecordType, mergedFields);
                }
                return new ARecord(openPartRecType, openFields);
            }
            return new ARecord(this.recordType, schemaFields);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean isExpandedRecord(DataInput in) throws IOException {
        in.readInt();
        if (this.recordType == null) {
            boolean exp = in.readBoolean();
            in.readInt();
            return exp;
        }
        if (this.recordType.isOpen()) {
            boolean exp = in.readBoolean();
            if (exp) {
                in.readInt();
            }
            return exp;
        }
        return false;
    }

    private IAObject[] getValuesForSchemaFields(DataInput in) throws IOException {
        if (this.numberOfSchemaFields <= 0) {
            return NO_FIELDS;
        }
        in.readInt();
        boolean hasOptionalFields = NonTaggedFormatUtil.hasOptionalField(this.recordType);
        byte[] nullBitMap = null;
        if (hasOptionalFields) {
            int nullBitMapSize = (int)Math.ceil((double)this.numberOfSchemaFields / 4.0);
            nullBitMap = new byte[nullBitMapSize];
            in.readFully(nullBitMap);
        }
        for (int i = 0; i < this.numberOfSchemaFields; ++i) {
            in.readInt();
        }
        IAObject[] schemaFields = new IAObject[this.numberOfSchemaFields];
        for (int fieldId = 0; fieldId < this.numberOfSchemaFields; ++fieldId) {
            schemaFields[fieldId] = hasOptionalFields && (nullBitMap[fieldId / 4] & 1 << 7 - 2 * (fieldId % 4)) == 0 ? ANull.NULL : (hasOptionalFields && (nullBitMap[fieldId / 4] & 1 << 7 - 2 * (fieldId % 4) - 1) == 0 ? AMissing.MISSING : (IAObject)this.deserializers[fieldId].deserialize(in));
        }
        return schemaFields;
    }

    public void serialize(ARecord instance, DataOutput out) throws HyracksDataException {
        this.serialize(instance, out, false);
    }

    public void serialize(ARecord instance, DataOutput out, boolean writeTypeTag) throws HyracksDataException {
        RecordBuilder recordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        recordBuilder.reset(this.recordType);
        recordBuilder.init();
        if (this.recordType != null) {
            for (int fieldIndex = 0; fieldIndex < this.recordType.getFieldNames().length; ++fieldIndex) {
                fieldValue.reset();
                this.serializers[fieldIndex].serialize((Object)instance.getValueByPos(fieldIndex), fieldValue.getDataOutput());
                recordBuilder.addField(fieldIndex, (IValueReference)fieldValue);
            }
            recordBuilder.write(out, writeTypeTag);
        } else {
            ARecordSerializerDeserializer.serializeSchemalessRecord(instance, out, writeTypeTag);
        }
    }

    public static void serializeSchemalessRecord(ARecord record, DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(BuiltinType.ASTRING);
        RecordBuilder confRecordBuilder = new RecordBuilder();
        confRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        ArrayBackedValueStorage fieldNameBytes = new ArrayBackedValueStorage();
        ArrayBackedValueStorage fieldValueBytes = new ArrayBackedValueStorage();
        for (int i = 0; i < record.getType().getFieldNames().length; ++i) {
            String fieldName = record.getType().getFieldNames()[i];
            fieldValueBytes.reset();
            fieldNameBytes.reset();
            stringSerde.serialize((Object)new AString(fieldName), fieldNameBytes.getDataOutput());
            ISerializerDeserializer valueSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(record.getType().getFieldTypes()[i]);
            valueSerde.serialize((Object)record.getValueByPos(i), fieldValueBytes.getDataOutput());
            confRecordBuilder.addField((IValueReference)fieldNameBytes, (IValueReference)fieldValueBytes);
        }
        confRecordBuilder.write(dataOutput, writeTypeTag);
    }

    public static void serializeSimpleSchemalessRecord(List<Pair<String, String>> record, DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(BuiltinType.ASTRING);
        RecordBuilder confRecordBuilder = new RecordBuilder();
        confRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        ArrayBackedValueStorage fieldNameBytes = new ArrayBackedValueStorage();
        ArrayBackedValueStorage fieldValueBytes = new ArrayBackedValueStorage();
        for (int i = 0; i < record.size(); ++i) {
            fieldValueBytes.reset();
            fieldNameBytes.reset();
            stringSerde.serialize((Object)new AString((String)record.get((int)i).first), fieldNameBytes.getDataOutput());
            stringSerde.serialize((Object)new AString((String)record.get((int)i).second), fieldValueBytes.getDataOutput());
            confRecordBuilder.addField((IValueReference)fieldNameBytes, (IValueReference)fieldValueBytes);
        }
        confRecordBuilder.write(dataOutput, writeTypeTag);
    }

    private IAObject[] mergeFields(IAObject[] closedFields, IAObject[] openFields) {
        IAObject[] fields = new IAObject[closedFields.length + openFields.length];
        for (int i = 0; i < closedFields.length; ++i) {
            fields[i] = closedFields[i];
        }
        for (int j = 0; j < openFields.length; ++j) {
            fields[closedFields.length + j] = openFields[j];
        }
        return fields;
    }

    private ARecordType mergeRecordTypes(ARecordType recType1, ARecordType recType2) {
        int i;
        String[] fieldNames = new String[recType1.getFieldNames().length + recType2.getFieldNames().length];
        IAType[] fieldTypes = new IAType[recType1.getFieldTypes().length + recType2.getFieldTypes().length];
        for (i = 0; i < recType1.getFieldNames().length; ++i) {
            fieldNames[i] = recType1.getFieldNames()[i];
            fieldTypes[i] = recType1.getFieldTypes()[i];
        }
        for (int j = 0; j < recType2.getFieldNames().length; ++j) {
            fieldNames[i] = recType2.getFieldNames()[j];
            fieldTypes[i] = recType2.getFieldTypes()[j];
            ++i;
        }
        return new ARecordType(null, fieldNames, fieldTypes, true);
    }

    public static final int getRecordLength(byte[] serRecord, int offset) {
        return AInt32SerializerDeserializer.getInt(serRecord, offset);
    }

    public static int getFieldOffsetById(byte[] serRecord, int offset, int fieldId, int nullBitmapSize, boolean isOpen) {
        byte nullTestCode = (byte)(1 << 7 - 2 * (fieldId % 4));
        byte missingTestCode = (byte)(1 << 7 - 2 * (fieldId % 4) - 1);
        if (serRecord[offset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
            return -1;
        }
        int pointer = offset + 5;
        if (isOpen) {
            boolean isExpanded = serRecord[pointer] == 1;
            pointer += 1 + (isExpanded ? 4 : 0);
        }
        pointer += 4;
        if (nullBitmapSize > 0) {
            int pos = pointer + fieldId / 4;
            if ((serRecord[pos] & nullTestCode) == 0) {
                return 0;
            }
            if ((serRecord[pos] & missingTestCode) == 0) {
                return -1;
            }
        }
        return offset + AInt32SerializerDeserializer.getInt(serRecord, pointer + nullBitmapSize + 4 * fieldId);
    }

    public static int getFieldOffsetByName(byte[] serRecord, int start, int len, byte[] fieldName, int nstart) throws HyracksDataException {
        if (ARecordSerializerDeserializer.hasNoFields(serRecord, start, len) || serRecord[start + 5] != 1) {
            return -1;
        }
        int openPartOffset = start + AInt32SerializerDeserializer.getInt(serRecord, start + 6);
        int numberOfOpenField = AInt32SerializerDeserializer.getInt(serRecord, openPartOffset);
        int fieldUtflength = UTF8StringUtil.getUTFLength((byte[])fieldName, (int)(nstart + 1));
        int fieldUtfMetaLen = UTF8StringUtil.getNumBytesToStoreLength((int)fieldUtflength);
        IBinaryHashFunction utf8HashFunction = BinaryHashFunctionFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryHashFunction();
        IBinaryComparator utf8BinaryComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
        int fieldNameHashCode = utf8HashFunction.hash(fieldName, nstart + 1, fieldUtflength + fieldUtfMetaLen);
        int offset = openPartOffset + 4;
        int fieldOffset = -1;
        int mid = 0;
        int high = numberOfOpenField - 1;
        int low = 0;
        while (low <= high) {
            mid = (high + low) / 2;
            int h = AInt32SerializerDeserializer.getInt(serRecord, offset + 8 * mid);
            if (h == fieldNameHashCode) {
                fieldOffset = start + AInt32SerializerDeserializer.getInt(serRecord, offset + 8 * mid + 4);
                if (utf8BinaryComparator.compare(serRecord, fieldOffset, len, fieldName, nstart + 1, fieldUtflength + fieldUtfMetaLen) == 0) {
                    return fieldOffset + fieldUtfMetaLen + fieldUtflength;
                }
                for (int j = mid + 1; j < numberOfOpenField && (h = AInt32SerializerDeserializer.getInt(serRecord, offset + 8 * j)) == fieldNameHashCode; ++j) {
                    fieldOffset = start + AInt32SerializerDeserializer.getInt(serRecord, offset + 8 * j + 4);
                    if (utf8BinaryComparator.compare(serRecord, fieldOffset, len, fieldName, nstart + 1, fieldUtflength) != 0) continue;
                    return fieldOffset + fieldUtfMetaLen + fieldUtflength;
                }
            }
            if (fieldNameHashCode > h) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -1;
    }

    public static boolean hasNoFields(byte[] serRecord, int start, int len) {
        return serRecord[start] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG || len <= 6;
    }

    public String toString() {
        return " ";
    }
}

