/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class TypeResolverUtil {
    private TypeResolverUtil() {
    }

    public static IAType resolve(List<IAType> inputTypes) {
        IAType currentType = null;
        for (IAType type : inputTypes) {
            currentType = currentType == null ? type : TypeResolverUtil.generalizeTypes(currentType, type);
        }
        return currentType;
    }

    public static IAType resolve(IAType ... inputTypes) {
        IAType currentType = null;
        for (IAType type : inputTypes) {
            currentType = currentType == null ? type : TypeResolverUtil.generalizeTypes(currentType, type);
        }
        return currentType;
    }

    public static boolean needsCast(IAType reqType, IAType inputType) {
        ATypeTag tag = inputType.getTypeTag();
        if (tag == ATypeTag.UNION) {
            tag = ((AUnionType)inputType).getActualType().getTypeTag();
        }
        if (tag != ATypeTag.OBJECT && tag != ATypeTag.MULTISET && tag != ATypeTag.ARRAY) {
            return false;
        }
        return !TypeComputeUtils.getActualType(reqType).equals(TypeComputeUtils.getActualType(inputType));
    }

    private static IAType generalizeTypes(IAType inputLeftType, IAType inputRightType) {
        IAType leftType = inputLeftType;
        IAType rightType = inputRightType;
        ATypeTag leftTypeTag = leftType.getTypeTag();
        ATypeTag rightTypeTag = rightType.getTypeTag();
        boolean unknownable = false;
        if (leftTypeTag == ATypeTag.UNION || rightTypeTag == ATypeTag.UNION) {
            leftType = TypeComputeUtils.getActualType(leftType);
            rightType = TypeComputeUtils.getActualType(leftType);
            leftTypeTag = leftType.getTypeTag();
            rightTypeTag = rightType.getTypeTag();
            unknownable = true;
        }
        if (leftType.equals(rightType)) {
            return unknownable ? AUnionType.createUnknownableType(leftType) : leftType;
        }
        if (leftTypeTag == ATypeTag.MISSING || leftTypeTag == ATypeTag.NULL) {
            return AUnionType.createUnknownableType(rightType);
        }
        if (rightTypeTag == ATypeTag.MISSING || rightTypeTag == ATypeTag.NULL) {
            return AUnionType.createUnknownableType(leftType);
        }
        if (leftTypeTag != rightTypeTag) {
            return BuiltinType.ANY;
        }
        IAType generalizedComplexType = TypeResolverUtil.generalizeComplexTypes(leftTypeTag, leftType, rightType);
        return unknownable ? AUnionType.createUnknownableType(generalizedComplexType) : generalizedComplexType;
    }

    private static IAType generalizeComplexTypes(ATypeTag typeTag, IAType leftType, IAType rightType) {
        switch (typeTag) {
            case OBJECT: {
                return TypeResolverUtil.generalizeRecordTypes((ARecordType)leftType, (ARecordType)rightType);
            }
            case ARRAY: {
                return TypeResolverUtil.generalizeOrderedListTypes((AOrderedListType)leftType, (AOrderedListType)rightType);
            }
            case MULTISET: {
                return TypeResolverUtil.generalizeUnorderedListTypes((AUnorderedListType)leftType, (AUnorderedListType)rightType);
            }
        }
        return BuiltinType.ANY;
    }

    private static ARecordType generalizeRecordTypes(ARecordType leftType, ARecordType rightType) {
        boolean knowsAdditonalFieldNames = true;
        HashSet<String> allPossibleAdditionalFieldNames = new HashSet<String>();
        if (leftType.isOpen() && !leftType.knowsAllPossibleAdditonalFieldNames()) {
            knowsAdditonalFieldNames = false;
        } else if (leftType.isOpen()) {
            allPossibleAdditionalFieldNames.addAll(leftType.getAllPossibleAdditonalFieldNames());
        }
        if (rightType.isOpen() && !rightType.knowsAllPossibleAdditonalFieldNames()) {
            knowsAdditonalFieldNames = false;
        } else if (rightType.isOpen()) {
            allPossibleAdditionalFieldNames.addAll(rightType.getAllPossibleAdditonalFieldNames());
        }
        boolean canBeClosed = !leftType.isOpen() && !rightType.isOpen();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<IAType> fieldTypes = new ArrayList<IAType>();
        boolean leftAllMatched = TypeResolverUtil.generalizeRecordFields(leftType, rightType, allPossibleAdditionalFieldNames, fieldNames, fieldTypes);
        boolean rightAllMatched = TypeResolverUtil.generalizeRecordFields(rightType, leftType, allPossibleAdditionalFieldNames, fieldNames, fieldTypes);
        return new ARecordType("generalized-record-type", fieldNames.toArray(new String[fieldNames.size()]), fieldTypes.toArray(new IAType[fieldTypes.size()]), !canBeClosed || !leftAllMatched || !rightAllMatched, knowsAdditonalFieldNames ? allPossibleAdditionalFieldNames : null);
    }

    private static boolean generalizeRecordFields(ARecordType leftType, ARecordType rightType, Set<String> allPossibleAdditionalFieldNames, List<String> fieldNames, List<IAType> fieldTypes) {
        boolean allMatched = true;
        HashSet<String> existingFieldNames = new HashSet<String>(fieldNames);
        for (String fieldName : leftType.getFieldNames()) {
            IAType generalizedFieldType;
            IAType leftFieldType = leftType.getFieldType(fieldName);
            IAType rightFieldType = rightType.getFieldType(fieldName);
            IAType iAType = generalizedFieldType = rightFieldType == null ? null : TypeResolverUtil.generalizeTypes(leftFieldType, rightFieldType);
            if (generalizedFieldType == null || generalizedFieldType.equals(BuiltinType.ANY)) {
                allPossibleAdditionalFieldNames.add(fieldName);
                allMatched = false;
                continue;
            }
            if (existingFieldNames.contains(fieldName)) continue;
            fieldNames.add(fieldName);
            fieldTypes.add(generalizedFieldType);
        }
        return allMatched;
    }

    private static AOrderedListType generalizeOrderedListTypes(AOrderedListType leftType, AOrderedListType rightType) {
        return new AOrderedListType(TypeResolverUtil.processItemType(TypeResolverUtil.generalizeTypes(leftType.getItemType(), rightType.getItemType())), "generalized-ordered-list");
    }

    private static AUnorderedListType generalizeUnorderedListTypes(AUnorderedListType leftType, AUnorderedListType rightType) {
        return new AUnorderedListType(TypeResolverUtil.processItemType(TypeResolverUtil.generalizeTypes(leftType.getItemType(), rightType.getItemType())), "generalized-unordered-list");
    }

    private static IAType processItemType(IAType type) {
        ATypeTag tag = type.getTypeTag();
        return tag == ATypeTag.UNION ? BuiltinType.ANY : type;
    }
}

