/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.GatherFunctionCallsVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.IndependentSubquery;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.parser.FunctionParser;
import org.apache.asterix.lang.sqlpp.parser.SqlppParserFactory;
import org.apache.asterix.lang.sqlpp.rewrites.SqlppFunctionBodyRewriterFactory;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.GenerateColumnNameVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineColumnAliasVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.InlineWithExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.OperatorExpressionVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SetOperationVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppBuiltinFunctionRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGlobalAggregationSugarVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppInlineUdfsVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppListInputFunctionRewriteVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SubstituteGroupbyExpressionWithVariableVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.VariableCheckAndRewriteVisitor;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;

class SqlppQueryRewriter
implements IQueryRewriter {
    private static final String INLINE_WITH = "inline_with";
    private static final String NOT_INLINE_WITH = "false";
    private final FunctionParser functionRepository = new FunctionParser(new SqlppParserFactory());
    private IReturningStatement topExpr;
    private List<FunctionDecl> declaredFunctions;
    private LangRewritingContext context;
    private MetadataProvider metadataProvider;

    SqlppQueryRewriter() {
    }

    protected void setup(List<FunctionDecl> declaredFunctions, IReturningStatement topExpr, MetadataProvider metadataProvider, LangRewritingContext context) {
        this.topExpr = topExpr;
        this.context = context;
        this.declaredFunctions = declaredFunctions;
        this.metadataProvider = metadataProvider;
    }

    public void rewrite(List<FunctionDecl> declaredFunctions, IReturningStatement topStatement, MetadataProvider metadataProvider, LangRewritingContext context) throws CompilationException {
        if (topStatement == null) {
            return;
        }
        context.markCounter();
        this.setup(declaredFunctions, topStatement, metadataProvider, context);
        this.inlineColumnAlias();
        this.generateColumnNames();
        this.substituteGroupbyKeyExpression();
        this.rewriteGlobalAggregations();
        this.rewriteGroupBys();
        this.rewriteSetOperations();
        this.rewriteOperatorExpression();
        this.variableCheckAndRewrite(true);
        this.inlineWithExpressions();
        this.rewriteListInputFunctions();
        this.inlineDeclaredUdfs();
        this.rewriteFunctionNames();
        context.resetCounter();
        this.variableCheckAndRewrite(true);
        topStatement.setVarCounter(context.getVarCounter());
    }

    protected void rewriteGlobalAggregations() throws CompilationException {
        SqlppGlobalAggregationSugarVisitor globalAggregationVisitor = new SqlppGlobalAggregationSugarVisitor();
        this.topExpr.accept((ILangVisitor)globalAggregationVisitor, null);
    }

    protected void rewriteListInputFunctions() throws CompilationException {
        SqlppListInputFunctionRewriteVisitor listInputFunctionVisitor = new SqlppListInputFunctionRewriteVisitor();
        this.topExpr.accept((ILangVisitor)listInputFunctionVisitor, null);
    }

    protected void rewriteFunctionNames() throws CompilationException {
        SqlppBuiltinFunctionRewriteVisitor functionNameMapVisitor = new SqlppBuiltinFunctionRewriteVisitor();
        this.topExpr.accept((ILangVisitor)functionNameMapVisitor, null);
    }

    protected void inlineWithExpressions() throws CompilationException {
        String inlineWith = (String)this.metadataProvider.getConfig().get(INLINE_WITH);
        if (inlineWith != null && inlineWith.equalsIgnoreCase(NOT_INLINE_WITH)) {
            return;
        }
        InlineWithExpressionVisitor inlineWithExpressionVisitor = new InlineWithExpressionVisitor(this.context);
        this.topExpr.accept((ILangVisitor)inlineWithExpressionVisitor, null);
    }

    protected void generateColumnNames() throws CompilationException {
        GenerateColumnNameVisitor generateColumnNameVisitor = new GenerateColumnNameVisitor(this.context);
        this.topExpr.accept((ILangVisitor)generateColumnNameVisitor, null);
    }

    protected void substituteGroupbyKeyExpression() throws CompilationException {
        SubstituteGroupbyExpressionWithVariableVisitor substituteGbyExprVisitor = new SubstituteGroupbyExpressionWithVariableVisitor(this.context);
        this.topExpr.accept((ILangVisitor)substituteGbyExprVisitor, null);
    }

    protected void rewriteSetOperations() throws CompilationException {
        SetOperationVisitor setOperationVisitor = new SetOperationVisitor(this.context);
        this.topExpr.accept((ILangVisitor)setOperationVisitor, null);
    }

    protected void rewriteOperatorExpression() throws CompilationException {
        OperatorExpressionVisitor operatorExpressionVisitor = new OperatorExpressionVisitor(this.context);
        this.topExpr.accept((ILangVisitor)operatorExpressionVisitor, null);
    }

    protected void inlineColumnAlias() throws CompilationException {
        InlineColumnAliasVisitor inlineColumnAliasVisitor = new InlineColumnAliasVisitor(this.context);
        this.topExpr.accept((ILangVisitor)inlineColumnAliasVisitor, null);
    }

    protected void variableCheckAndRewrite(boolean overwrite) throws CompilationException {
        VariableCheckAndRewriteVisitor variableCheckAndRewriteVisitor = new VariableCheckAndRewriteVisitor(this.context, overwrite, this.metadataProvider);
        this.topExpr.accept((ILangVisitor)variableCheckAndRewriteVisitor, null);
    }

    protected void rewriteGroupBys() throws CompilationException {
        SqlppGroupByVisitor groupByVisitor = new SqlppGroupByVisitor(this.context);
        this.topExpr.accept((ILangVisitor)groupByVisitor, null);
    }

    protected void inlineDeclaredUdfs() throws CompilationException {
        ArrayList<FunctionSignature> funIds = new ArrayList<FunctionSignature>();
        for (FunctionDecl functionDecl : this.declaredFunctions) {
            funIds.add(functionDecl.getSignature());
        }
        ArrayList usedStoredFunctionDecls = new ArrayList();
        for (Expression topLevelExpr : this.topExpr.getDirectlyEnclosedExpressions()) {
            usedStoredFunctionDecls.addAll(FunctionUtil.retrieveUsedStoredFunctions((MetadataProvider)this.metadataProvider, (Expression)topLevelExpr, funIds, null, expr -> this.getFunctionCalls(expr), func -> this.functionRepository.getFunctionDecl(func), signature -> FunctionMapUtil.normalizeBuiltinFunctionSignature(signature, false)));
        }
        this.declaredFunctions.addAll(usedStoredFunctionDecls);
        if (!this.declaredFunctions.isEmpty()) {
            SqlppInlineUdfsVisitor sqlppInlineUdfsVisitor = new SqlppInlineUdfsVisitor(this.context, new SqlppFunctionBodyRewriterFactory(), this.declaredFunctions, this.metadataProvider);
            while (((Boolean)this.topExpr.accept((ILangVisitor)sqlppInlineUdfsVisitor, this.declaredFunctions)).booleanValue()) {
            }
        }
        this.declaredFunctions.removeAll(usedStoredFunctionDecls);
    }

    private Set<FunctionSignature> getFunctionCalls(Expression expression) throws CompilationException {
        GatherFunctionCalls gfc = new GatherFunctionCalls();
        expression.accept((ILangVisitor)gfc, null);
        return gfc.getCalls();
    }

    private static class GatherFunctionCalls
    extends GatherFunctionCallsVisitor
    implements ISqlppVisitor<Void, Void> {
        @Override
        public Void visit(FromClause fromClause, Void arg) throws CompilationException {
            for (FromTerm fromTerm : fromClause.getFromTerms()) {
                fromTerm.accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(FromTerm fromTerm, Void arg) throws CompilationException {
            fromTerm.getLeftExpression().accept((ILangVisitor)this, (Object)arg);
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                correlateClause.accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(JoinClause joinClause, Void arg) throws CompilationException {
            joinClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
            joinClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(NestClause nestClause, Void arg) throws CompilationException {
            nestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
            nestClause.getConditionExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(Projection projection, Void arg) throws CompilationException {
            if (!projection.star()) {
                projection.getExpression().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectBlock selectBlock, Void arg) throws CompilationException {
            if (selectBlock.hasFromClause()) {
                selectBlock.getFromClause().accept(this, arg);
            }
            if (selectBlock.hasLetClauses()) {
                for (LetClause letClause : selectBlock.getLetList()) {
                    letClause.accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (selectBlock.hasWhereClause()) {
                selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)arg);
            }
            if (selectBlock.hasGroupbyClause()) {
                selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)arg);
            }
            if (selectBlock.hasLetClausesAfterGroupby()) {
                for (LetClause letClause : selectBlock.getLetListAfterGroupby()) {
                    letClause.accept((ILangVisitor)this, (Object)arg);
                }
            }
            if (selectBlock.hasHavingClause()) {
                selectBlock.getHavingClause().accept(this, arg);
            }
            selectBlock.getSelectClause().accept(this, arg);
            return null;
        }

        @Override
        public Void visit(SelectClause selectClause, Void arg) throws CompilationException {
            if (selectClause.selectElement()) {
                selectClause.getSelectElement().accept(this, arg);
            } else {
                selectClause.getSelectRegular().accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectElement selectElement, Void arg) throws CompilationException {
            selectElement.getExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(SelectRegular selectRegular, Void arg) throws CompilationException {
            for (Projection projection : selectRegular.getProjections()) {
                projection.accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectSetOperation selectSetOperation, Void arg) throws CompilationException {
            selectSetOperation.getLeftInput().accept(this, arg);
            for (SetOperationRight setOperationRight : selectSetOperation.getRightInputs()) {
                setOperationRight.getSetOperationRightInput().accept(this, arg);
            }
            return null;
        }

        @Override
        public Void visit(SelectExpression selectStatement, Void arg) throws CompilationException {
            selectStatement.getSelectSetOperation().accept(this, arg);
            if (selectStatement.hasOrderby()) {
                selectStatement.getOrderbyClause().accept((ILangVisitor)this, (Object)arg);
            }
            if (selectStatement.hasLimit()) {
                selectStatement.getLimitClause().accept((ILangVisitor)this, (Object)arg);
            }
            return null;
        }

        @Override
        public Void visit(UnnestClause unnestClause, Void arg) throws CompilationException {
            unnestClause.getRightExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(HavingClause havingClause, Void arg) throws CompilationException {
            havingClause.getFilterExpression().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(IndependentSubquery independentSubquery, Void arg) throws CompilationException {
            independentSubquery.getExpr().accept((ILangVisitor)this, (Object)arg);
            return null;
        }

        @Override
        public Void visit(CaseExpression caseExpression, Void arg) throws CompilationException {
            caseExpression.getConditionExpr().accept((ILangVisitor)this, (Object)arg);
            for (Expression expr : caseExpression.getWhenExprs()) {
                expr.accept((ILangVisitor)this, (Object)arg);
            }
            for (Expression expr : caseExpression.getThenExprs()) {
                expr.accept((ILangVisitor)this, (Object)arg);
            }
            caseExpression.getElseExpr().accept((ILangVisitor)this, (Object)arg);
            return null;
        }
    }
}

